/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadata;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadataRepository;
import org.springframework.security.saml2.provider.service.registration.BaseOpenSamlAssertingPartyMetadataRepository;
import org.springframework.util.Assert;

public final class OpenSaml5AssertingPartyMetadataRepository
implements AssertingPartyMetadataRepository {
    private final BaseOpenSamlAssertingPartyMetadataRepository delegate;

    public OpenSaml5AssertingPartyMetadataRepository(MetadataResolver metadataResolver) {
        Assert.notNull((Object)metadataResolver, (String)"metadataResolver cannot be null");
        this.delegate = new BaseOpenSamlAssertingPartyMetadataRepository(new CriteriaSetResolverWrapper(metadataResolver));
    }

    @Override
    @NonNull
    public Iterator<AssertingPartyMetadata> iterator() {
        return this.delegate.iterator();
    }

    @Override
    @Nullable
    public AssertingPartyMetadata findByEntityId(String entityId) {
        return this.delegate.findByEntityId(entityId);
    }

    public static MetadataLocationRepositoryBuilder withTrustedMetadataLocation(String metadataLocation) {
        return new MetadataLocationRepositoryBuilder(metadataLocation, true);
    }

    public static MetadataLocationRepositoryBuilder withMetadataLocation(String metadataLocation) {
        return new MetadataLocationRepositoryBuilder(metadataLocation, false);
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    private static final class CriteriaSetResolverWrapper
    extends BaseOpenSamlAssertingPartyMetadataRepository.MetadataResolverAdapter {
        CriteriaSetResolverWrapper(MetadataResolver metadataResolver) {
            super(metadataResolver);
        }

        @Override
        EntityDescriptor resolveSingle(EntityIdCriterion entityId) throws Exception {
            return (EntityDescriptor)this.metadataResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{entityId}));
        }

        @Override
        Iterable<EntityDescriptor> resolve(EntityRoleCriterion role) throws Exception {
            return this.metadataResolver.resolve((Object)new CriteriaSet(new Criterion[]{role}));
        }
    }

    public static final class MetadataLocationRepositoryBuilder {
        private final String metadataLocation;
        private final boolean requireVerificationCredentials;
        private final Collection<Credential> verificationCredentials = new ArrayList<Credential>();
        private ResourceLoader resourceLoader = new DefaultResourceLoader();

        MetadataLocationRepositoryBuilder(String metadataLocation, boolean trusted) {
            this.metadataLocation = metadataLocation;
            this.requireVerificationCredentials = !trusted;
        }

        public MetadataLocationRepositoryBuilder verificationCredentials(Consumer<Collection<Credential>> credentials) {
            credentials.accept(this.verificationCredentials);
            return this;
        }

        public MetadataLocationRepositoryBuilder resourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
            return this;
        }

        public OpenSaml5AssertingPartyMetadataRepository build() {
            return new OpenSaml5AssertingPartyMetadataRepository(this.metadataResolver());
        }

        private MetadataResolver metadataResolver() {
            ResourceBackedMetadataResolver metadataResolver = this.resourceBackedMetadataResolver();
            boolean missingCredentials = this.requireVerificationCredentials && this.verificationCredentials.isEmpty();
            Assert.isTrue((!missingCredentials ? 1 : 0) != 0, (String)"Verification credentials are required");
            return this.initialize(metadataResolver);
        }

        private ResourceBackedMetadataResolver resourceBackedMetadataResolver() {
            Resource resource = this.resourceLoader.getResource(this.metadataLocation);
            try {
                ResourceBackedMetadataResolver metadataResolver = new ResourceBackedMetadataResolver((net.shibboleth.shared.resource.Resource)new SpringResource(resource));
                if (this.verificationCredentials.isEmpty()) {
                    return metadataResolver;
                }
                ExplicitKeySignatureTrustEngine engine = new ExplicitKeySignatureTrustEngine((CredentialResolver)new CollectionCredentialResolver(this.verificationCredentials), DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
                SignatureValidationFilter filter = new SignatureValidationFilter((SignatureTrustEngine)engine);
                filter.setRequireSignedRoot(true);
                metadataResolver.setMetadataFilter((MetadataFilter)filter);
                filter.initialize();
                return metadataResolver;
            }
            catch (Exception ex) {
                throw new Saml2Exception(ex);
            }
        }

        private MetadataResolver initialize(ResourceBackedMetadataResolver metadataResolver) {
            metadataResolver.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
            return BaseOpenSamlAssertingPartyMetadataRepository.initialize(metadataResolver);
        }

        private static final class SpringResource
        implements net.shibboleth.shared.resource.Resource {
            private final Resource resource;

            SpringResource(Resource resource) {
                this.resource = resource;
            }

            public boolean exists() {
                return this.resource.exists();
            }

            public boolean isReadable() {
                return this.resource.isReadable();
            }

            public boolean isOpen() {
                return this.resource.isOpen();
            }

            public URL getURL() throws IOException {
                return this.resource.getURL();
            }

            public URI getURI() throws IOException {
                return this.resource.getURI();
            }

            public File getFile() throws IOException {
                return this.resource.getFile();
            }

            @Nonnull
            public InputStream getInputStream() throws IOException {
                return this.resource.getInputStream();
            }

            public long contentLength() throws IOException {
                return this.resource.contentLength();
            }

            public long lastModified() throws IOException {
                return this.resource.lastModified();
            }

            public net.shibboleth.shared.resource.Resource createRelativeResource(String relativePath) throws IOException {
                return new SpringResource(this.resource.createRelative(relativePath));
            }

            public String getFilename() {
                return this.resource.getFilename();
            }

            public String getDescription() {
                return this.resource.getDescription();
            }
        }
    }
}

