/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.BaseOpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4Template;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.util.Assert;

public final class OpenSaml4AuthenticationProvider
implements AuthenticationProvider {
    private final BaseOpenSamlAuthenticationProvider delegate = new BaseOpenSamlAuthenticationProvider(new OpenSaml4Template());

    public void setResponseElementsDecrypter(Consumer<ResponseToken> responseElementsDecrypter) {
        Assert.notNull(responseElementsDecrypter, (String)"responseElementsDecrypter cannot be null");
        this.delegate.setResponseElementsDecrypter((BaseOpenSamlAuthenticationProvider.ResponseToken token) -> responseElementsDecrypter.accept(new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token)));
    }

    public void setResponseValidator(Converter<ResponseToken, Saml2ResponseValidatorResult> responseValidator) {
        Assert.notNull(responseValidator, (String)"responseValidator cannot be null");
        this.delegate.setResponseValidator((Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, Saml2ResponseValidatorResult>)((Converter)token -> (Saml2ResponseValidatorResult)responseValidator.convert((Object)new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token))));
    }

    public void setAssertionValidator(Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator) {
        Assert.notNull(assertionValidator, (String)"assertionValidator cannot be null");
        this.delegate.setAssertionValidator((Converter<BaseOpenSamlAuthenticationProvider.AssertionToken, Saml2ResponseValidatorResult>)((Converter)token -> (Saml2ResponseValidatorResult)assertionValidator.convert((Object)new AssertionToken((BaseOpenSamlAuthenticationProvider.AssertionToken)token))));
    }

    public void setAssertionElementsDecrypter(Consumer<AssertionToken> assertionDecrypter) {
        Assert.notNull(assertionDecrypter, (String)"assertionDecrypter cannot be null");
        this.delegate.setAssertionElementsDecrypter((BaseOpenSamlAuthenticationProvider.AssertionToken token) -> assertionDecrypter.accept(new AssertionToken((BaseOpenSamlAuthenticationProvider.AssertionToken)token)));
    }

    public void setResponseAuthenticationConverter(Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter) {
        Assert.notNull(responseAuthenticationConverter, (String)"responseAuthenticationConverter cannot be null");
        this.delegate.setResponseAuthenticationConverter((Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, ? extends AbstractAuthenticationToken>)((Converter)token -> (AbstractAuthenticationToken)responseAuthenticationConverter.convert((Object)new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token))));
    }

    public static Converter<ResponseToken, Saml2ResponseValidatorResult> createDefaultResponseValidator() {
        Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, Saml2ResponseValidatorResult> delegate = BaseOpenSamlAuthenticationProvider.createDefaultResponseValidator();
        return token -> (Saml2ResponseValidatorResult)delegate.convert((Object)new BaseOpenSamlAuthenticationProvider.ResponseToken(token.getResponse(), token.getToken()));
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator() {
        return OpenSaml4AuthenticationProvider.createDefaultAssertionValidatorWithParameters(params -> params.put("saml2.ClockSkew", Duration.ofMinutes(5L)));
    }

    @Deprecated
    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator(Converter<AssertionToken, ValidationContext> contextConverter) {
        Converter contextDelegate = token -> (ValidationContext)contextConverter.convert((Object)new AssertionToken(token.getAssertion(), token.getToken()));
        Converter<BaseOpenSamlAuthenticationProvider.AssertionToken, Saml2ResponseValidatorResult> delegate = BaseOpenSamlAuthenticationProvider.createDefaultAssertionValidator((Converter<BaseOpenSamlAuthenticationProvider.AssertionToken, ValidationContext>)contextDelegate);
        return token -> (Saml2ResponseValidatorResult)delegate.convert((Object)new BaseOpenSamlAuthenticationProvider.AssertionToken(token.getAssertion(), token.getToken()));
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidatorWithParameters(Consumer<Map<String, Object>> validationContextParameters) {
        Converter<BaseOpenSamlAuthenticationProvider.AssertionToken, Saml2ResponseValidatorResult> delegate = BaseOpenSamlAuthenticationProvider.createDefaultAssertionValidatorWithParameters(validationContextParameters);
        return token -> (Saml2ResponseValidatorResult)delegate.convert((Object)new BaseOpenSamlAuthenticationProvider.AssertionToken(token.getAssertion(), token.getToken()));
    }

    public static Converter<ResponseToken, Saml2Authentication> createDefaultResponseAuthenticationConverter() {
        Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, Saml2Authentication> delegate = BaseOpenSamlAuthenticationProvider.createDefaultResponseAuthenticationConverter();
        return token -> (Saml2Authentication)((Object)((Object)delegate.convert((Object)new BaseOpenSamlAuthenticationProvider.ResponseToken(token.getResponse(), token.getToken()))));
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.delegate.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return authentication != null && Saml2AuthenticationToken.class.isAssignableFrom(authentication);
    }

    public static class ResponseToken {
        private final Saml2AuthenticationToken token;
        private final Response response;

        ResponseToken(Response response, Saml2AuthenticationToken token) {
            this.token = token;
            this.response = response;
        }

        ResponseToken(BaseOpenSamlAuthenticationProvider.ResponseToken token) {
            this.token = token.getToken();
            this.response = token.getResponse();
        }

        public Response getResponse() {
            return this.response;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    public static class AssertionToken {
        private final Saml2AuthenticationToken token;
        private final Assertion assertion;

        AssertionToken(Assertion assertion, Saml2AuthenticationToken token) {
            this.token = token;
            this.assertion = assertion;
        }

        AssertionToken(BaseOpenSamlAuthenticationProvider.AssertionToken token) {
            this.token = token.getToken();
            this.assertion = token.getAssertion();
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }
}

