/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSamlOperations;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2Utils;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.ParameterRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatchers;
import org.springframework.util.Assert;

class BaseOpenSamlAuthenticationRequestResolver
implements Saml2AuthenticationRequestResolver {
    private final OpenSamlOperations saml;
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private final AuthnRequestBuilder authnRequestBuilder;
    private final AuthnRequestMarshaller marshaller;
    private final IssuerBuilder issuerBuilder;
    private final NameIDBuilder nameIdBuilder;
    private final NameIDPolicyBuilder nameIdPolicyBuilder;
    private RequestMatcher requestMatcher = RequestMatchers.anyOf((RequestMatcher[])new RequestMatcher[]{new AntPathRequestMatcher("/saml2/authenticate/{registrationId}"), new AntPathQueryRequestMatcher("/saml2/authenticate", "registrationId={registrationId}")});
    private Clock clock = Clock.systemUTC();
    private Converter<HttpServletRequest, String> relayStateResolver = request -> UUID.randomUUID().toString();
    private Consumer<AuthnRequestParameters> parametersConsumer = parameters -> {};

    BaseOpenSamlAuthenticationRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver, OpenSamlOperations saml) {
        this.saml = saml;
        Assert.notNull((Object)relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.marshaller = (AuthnRequestMarshaller)registry.getMarshallerFactory().getMarshaller(AuthnRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.marshaller, (String)"authnRequestMarshaller must be configured in OpenSAML");
        this.authnRequestBuilder = (AuthnRequestBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.authnRequestBuilder, (String)"authnRequestBuilder must be configured in OpenSAML");
        this.issuerBuilder = (IssuerBuilder)registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.issuerBuilder, (String)"issuerBuilder must be configured in OpenSAML");
        this.nameIdBuilder = (NameIDBuilder)registry.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.nameIdBuilder, (String)"nameIdBuilder must be configured in OpenSAML");
        this.nameIdPolicyBuilder = (NameIDPolicyBuilder)registry.getBuilderFactory().getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.nameIdPolicyBuilder, (String)"nameIdPolicyBuilder must be configured in OpenSAML");
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    void setRelayStateResolver(Converter<HttpServletRequest, String> relayStateResolver) {
        this.relayStateResolver = relayStateResolver;
    }

    void setRequestMatcher(RequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
    }

    void setParametersConsumer(Consumer<AuthnRequestParameters> parametersConsumer) {
        this.parametersConsumer = parametersConsumer;
    }

    @Override
    public <T extends AbstractSaml2AuthenticationRequest> T resolve(HttpServletRequest request) {
        RequestMatcher.MatchResult result = this.requestMatcher.matcher(request);
        if (!result.isMatch()) {
            return null;
        }
        String registrationId = (String)result.getVariables().get("registrationId");
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, registrationId);
        if (registration == null) {
            return null;
        }
        RelyingPartyRegistrationPlaceholderResolvers.UriResolver uriResolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
        String entityId = uriResolver.resolve(registration.getEntityId());
        String assertionConsumerServiceLocation = uriResolver.resolve(registration.getAssertionConsumerServiceLocation());
        AuthnRequest authnRequest = this.authnRequestBuilder.buildObject();
        authnRequest.setForceAuthn(Boolean.FALSE);
        authnRequest.setIsPassive(Boolean.FALSE);
        authnRequest.setProtocolBinding(registration.getAssertionConsumerServiceBinding().getUrn());
        Issuer iss = this.issuerBuilder.buildObject();
        iss.setValue(entityId);
        authnRequest.setIssuer(iss);
        authnRequest.setDestination(registration.getAssertingPartyMetadata().getSingleSignOnServiceLocation());
        authnRequest.setAssertionConsumerServiceURL(assertionConsumerServiceLocation);
        if (registration.getNameIdFormat() != null) {
            NameIDPolicy nameIdPolicy = this.nameIdPolicyBuilder.buildObject();
            nameIdPolicy.setFormat(registration.getNameIdFormat());
            authnRequest.setNameIDPolicy(nameIdPolicy);
        }
        authnRequest.setIssueInstant(Instant.now(this.clock));
        this.parametersConsumer.accept(new AuthnRequestParameters(request, registration, authnRequest));
        if (authnRequest.getID() == null) {
            authnRequest.setID("ARQ" + UUID.randomUUID().toString().substring(1));
        }
        String relayState = (String)this.relayStateResolver.convert((Object)request);
        Saml2MessageBinding binding = registration.getAssertingPartyMetadata().getSingleSignOnServiceBinding();
        if (binding == Saml2MessageBinding.POST) {
            if (registration.getAssertingPartyMetadata().getWantAuthnRequestsSigned() || registration.isAuthnRequestsSigned()) {
                this.saml.withSigningKeys(registration.getSigningX509Credentials()).algorithms(registration.getAssertingPartyMetadata().getSigningAlgorithms()).sign((AuthnRequest)authnRequest);
            }
            String xml = this.serialize(authnRequest);
            String encoded = Saml2Utils.withDecoded(xml).encode();
            return (T)((Saml2PostAuthenticationRequest.Builder)((Saml2PostAuthenticationRequest.Builder)((Saml2PostAuthenticationRequest.Builder)Saml2PostAuthenticationRequest.withRelyingPartyRegistration(registration).samlRequest(encoded)).relayState(relayState)).id(authnRequest.getID())).build();
        }
        String xml = this.serialize(authnRequest);
        String deflatedAndEncoded = Saml2Utils.withDecoded(xml).deflate(true).encode();
        Saml2RedirectAuthenticationRequest.Builder builder = (Saml2RedirectAuthenticationRequest.Builder)((Saml2RedirectAuthenticationRequest.Builder)((Saml2RedirectAuthenticationRequest.Builder)Saml2RedirectAuthenticationRequest.withRelyingPartyRegistration(registration).samlRequest(deflatedAndEncoded)).relayState(relayState)).id(authnRequest.getID());
        if (registration.getAssertingPartyMetadata().getWantAuthnRequestsSigned() || registration.isAuthnRequestsSigned()) {
            HashMap<String, String> signingParameters = new HashMap<String, String>();
            signingParameters.put("SAMLRequest", deflatedAndEncoded);
            if (relayState != null) {
                signingParameters.put("RelayState", relayState);
            }
            Map<String, String> query = this.saml.withSigningKeys(registration.getSigningX509Credentials()).algorithms(registration.getAssertingPartyMetadata().getSigningAlgorithms()).sign(signingParameters);
            builder.sigAlg(query.get("SigAlg")).signature(query.get("Signature"));
        }
        return (T)builder.build();
    }

    private String serialize(AuthnRequest authnRequest) {
        return this.saml.serialize((XMLObject)authnRequest).serialize();
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    private static final class AntPathQueryRequestMatcher
    implements RequestMatcher {
        private final RequestMatcher matcher;

        AntPathQueryRequestMatcher(String path, String ... params) {
            ArrayList<Object> matchers = new ArrayList<Object>();
            matchers.add(new AntPathRequestMatcher(path));
            for (String param : params) {
                String[] parts = param.split("=");
                if (parts.length == 1) {
                    matchers.add(new ParameterRequestMatcher(parts[0]));
                    continue;
                }
                matchers.add(new ParameterRequestMatcher(parts[0], parts[1]));
            }
            this.matcher = new AndRequestMatcher(matchers);
        }

        public boolean matches(HttpServletRequest request) {
            return this.matcher(request).isMatch();
        }

        public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
            return this.matcher.matcher(request);
        }
    }

    static final class AuthnRequestParameters {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final AuthnRequest authnRequest;

        AuthnRequestParameters(HttpServletRequest request, RelyingPartyRegistration registration, AuthnRequest authnRequest) {
            this.request = request;
            this.registration = registration;
            this.authnRequest = authnRequest;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        AuthnRequest getAuthnRequest() {
            return this.authnRequest;
        }
    }
}

