/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

final class Saml2MessageBindingUtils {
    private Saml2MessageBindingUtils() {
    }

    static Saml2MessageBinding resolveBinding(HttpServletRequest request) {
        if (Saml2MessageBindingUtils.isHttpPostBinding(request)) {
            return Saml2MessageBinding.POST;
        }
        if (Saml2MessageBindingUtils.isHttpRedirectBinding(request)) {
            return Saml2MessageBinding.REDIRECT;
        }
        throw new Saml2Exception("Unable to determine message binding from request.");
    }

    private static boolean isSamlRequestResponse(HttpServletRequest request) {
        return request.getParameter("SAMLRequest") != null || request.getParameter("SAMLResponse") != null;
    }

    static boolean isHttpRedirectBinding(HttpServletRequest request) {
        return request != null && "GET".equalsIgnoreCase(request.getMethod()) && Saml2MessageBindingUtils.isSamlRequestResponse(request);
    }

    static boolean isHttpPostBinding(HttpServletRequest request) {
        return request != null && "POST".equalsIgnoreCase(request.getMethod()) && Saml2MessageBindingUtils.isSamlRequestResponse(request);
    }
}

