/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestContextResolver;
import org.springframework.util.Assert;

public final class DefaultSaml2AuthenticationRequestContextResolver
implements Saml2AuthenticationRequestContextResolver {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationResolver;

    @Deprecated
    public DefaultSaml2AuthenticationRequestContextResolver(Converter<HttpServletRequest, RelyingPartyRegistration> relyingPartyRegistrationResolver) {
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
    }

    public DefaultSaml2AuthenticationRequestContextResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.relyingPartyRegistrationResolver = request -> relyingPartyRegistrationResolver.resolve((HttpServletRequest)request, null);
    }

    @Override
    public Saml2AuthenticationRequestContext resolve(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request cannot be null");
        RelyingPartyRegistration relyingParty = (RelyingPartyRegistration)this.relyingPartyRegistrationResolver.convert((Object)request);
        if (relyingParty == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating SAML 2.0 Authentication Request for Asserting Party [" + relyingParty.getRegistrationId() + "]"));
        }
        return this.createRedirectAuthenticationRequestContext(request, relyingParty);
    }

    private Saml2AuthenticationRequestContext createRedirectAuthenticationRequestContext(HttpServletRequest request, RelyingPartyRegistration relyingParty) {
        return Saml2AuthenticationRequestContext.builder().issuer(relyingParty.getEntityId()).relyingPartyRegistration(relyingParty).assertionConsumerServiceUrl(relyingParty.getAssertionConsumerServiceLocation()).relayState(request.getParameter("RelayState")).build();
    }
}

