/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Saml2WebSsoAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String DEFAULT_FILTER_PROCESSES_URI = "/login/saml2/sso/{registrationId}";
    private final AuthenticationConverter authenticationConverter;

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        this(relyingPartyRegistrationRepository, DEFAULT_FILTER_PROCESSES_URI);
    }

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository, String filterProcessesUrl) {
        this(new Saml2AuthenticationTokenConverter(new DefaultRelyingPartyRegistrationResolver(relyingPartyRegistrationRepository)), filterProcessesUrl);
        Assert.isTrue((boolean)filterProcessesUrl.contains("{registrationId}"), (String)"filterProcessesUrl must contain a {registrationId} match variable");
    }

    public Saml2WebSsoAuthenticationFilter(AuthenticationConverter authenticationConverter, String filterProcessesUrl) {
        super(filterProcessesUrl);
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        Assert.hasText((String)filterProcessesUrl, (String)"filterProcessesUrl must contain a URL pattern");
        this.authenticationConverter = authenticationConverter;
        this.setAllowSessionCreation(true);
        this.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return super.requiresAuthentication(request, response) && StringUtils.hasText((String)request.getParameter("SAMLResponse"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Authentication authentication = this.authenticationConverter.convert(request);
        if (authentication == null) {
            Saml2Error saml2Error = new Saml2Error("relying_party_registration_not_found", "No relying party registration found");
            throw new Saml2AuthenticationException(saml2Error);
        }
        return this.getAuthenticationManager().authenticate(authentication);
    }
}

