/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.criteria.role.impl.EvaluableProtocolRoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.criteria.impl.EvaluableEntityIDCredentialCriterion;
import org.opensaml.security.credential.criteria.impl.EvaluableUsageCredentialCriterion;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.Saml2Utils;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.web.util.UriUtils;

final class OpenSamlVerificationUtils {
    static VerifierPartial verifySignature(StatusResponseType object, RelyingPartyRegistration registration) {
        return new VerifierPartial(object, registration);
    }

    static VerifierPartial verifySignature(RequestAbstractType object, RelyingPartyRegistration registration) {
        return new VerifierPartial(object, registration);
    }

    static SignatureTrustEngine trustEngine(RelyingPartyRegistration registration) {
        HashSet<BasicX509Credential> credentials = new HashSet<BasicX509Credential>();
        Collection<Saml2X509Credential> keys = registration.getAssertingPartyDetails().getVerificationX509Credentials();
        for (Saml2X509Credential key : keys) {
            BasicX509Credential cred = new BasicX509Credential(key.getCertificate());
            cred.setUsageType(UsageType.SIGNING);
            cred.setEntityId(registration.getAssertingPartyDetails().getEntityId());
            credentials.add(cred);
        }
        CollectionCredentialResolver credentialsResolver = new CollectionCredentialResolver(credentials);
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)credentialsResolver, DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
    }

    private OpenSamlVerificationUtils() {
    }

    static class VerifierPartial {
        private final String id;
        private final CriteriaSet criteria;
        private final SignatureTrustEngine trustEngine;

        VerifierPartial(StatusResponseType object, RelyingPartyRegistration registration) {
            this.id = object.getID();
            this.criteria = this.verificationCriteria(object.getIssuer());
            this.trustEngine = OpenSamlVerificationUtils.trustEngine(registration);
        }

        VerifierPartial(RequestAbstractType object, RelyingPartyRegistration registration) {
            this.id = object.getID();
            this.criteria = this.verificationCriteria(object.getIssuer());
            this.trustEngine = OpenSamlVerificationUtils.trustEngine(registration);
        }

        Saml2ResponseValidatorResult redirect(HttpServletRequest request, String objectParameterName) {
            RedirectSignature signature = new RedirectSignature(request, objectParameterName);
            if (signature.getAlgorithm() == null) {
                return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_signature", "Missing signature algorithm for object [" + this.id + "]"));
            }
            if (!signature.hasSignature()) {
                return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_signature", "Missing signature for object [" + this.id + "]"));
            }
            ArrayList<Saml2Error> errors = new ArrayList<Saml2Error>();
            String algorithmUri = signature.getAlgorithm();
            try {
                if (!this.trustEngine.validate(signature.getSignature(), signature.getContent(), algorithmUri, this.criteria, null)) {
                    errors.add(new Saml2Error("invalid_signature", "Invalid signature for object [" + this.id + "]"));
                }
            }
            catch (Exception ex) {
                errors.add(new Saml2Error("invalid_signature", "Invalid signature for object [" + this.id + "]: "));
            }
            return Saml2ResponseValidatorResult.failure(errors);
        }

        Saml2ResponseValidatorResult post(Signature signature) {
            ArrayList<Saml2Error> errors = new ArrayList<Saml2Error>();
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            try {
                profileValidator.validate(signature);
            }
            catch (Exception ex) {
                errors.add(new Saml2Error("invalid_signature", "Invalid signature for object [" + this.id + "]: "));
            }
            try {
                if (!this.trustEngine.validate((Object)signature, this.criteria)) {
                    errors.add(new Saml2Error("invalid_signature", "Invalid signature for object [" + this.id + "]"));
                }
            }
            catch (Exception ex) {
                errors.add(new Saml2Error("invalid_signature", "Invalid signature for object [" + this.id + "]: "));
            }
            return Saml2ResponseValidatorResult.failure(errors);
        }

        private CriteriaSet verificationCriteria(Issuer issuer) {
            CriteriaSet criteria = new CriteriaSet();
            criteria.add((Object)new EvaluableEntityIDCredentialCriterion(new EntityIdCriterion(issuer.getValue())));
            criteria.add((Object)new EvaluableProtocolRoleDescriptorCriterion(new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")));
            criteria.add((Object)new EvaluableUsageCredentialCriterion(new UsageCriterion(UsageType.SIGNING)));
            return criteria;
        }

        private static class RedirectSignature {
            private final HttpServletRequest request;
            private final String objectParameterName;

            RedirectSignature(HttpServletRequest request, String objectParameterName) {
                this.request = request;
                this.objectParameterName = objectParameterName;
            }

            String getAlgorithm() {
                return this.request.getParameter("SigAlg");
            }

            byte[] getContent() {
                if (this.request.getParameter("RelayState") != null) {
                    return String.format("%s=%s&RelayState=%s&SigAlg=%s", this.objectParameterName, UriUtils.encode((String)this.request.getParameter(this.objectParameterName), (Charset)StandardCharsets.ISO_8859_1), UriUtils.encode((String)this.request.getParameter("RelayState"), (Charset)StandardCharsets.ISO_8859_1), UriUtils.encode((String)this.getAlgorithm(), (Charset)StandardCharsets.ISO_8859_1)).getBytes(StandardCharsets.UTF_8);
                }
                return String.format("%s=%s&SigAlg=%s", this.objectParameterName, UriUtils.encode((String)this.request.getParameter(this.objectParameterName), (Charset)StandardCharsets.ISO_8859_1), UriUtils.encode((String)this.getAlgorithm(), (Charset)StandardCharsets.ISO_8859_1)).getBytes(StandardCharsets.UTF_8);
            }

            byte[] getSignature() {
                return Saml2Utils.samlDecode(this.request.getParameter("Signature"));
            }

            boolean hasSignature() {
                return this.request.getParameter("Signature") != null;
            }
        }
    }
}

