/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.util.Assert;

public class RelyingPartyRegistration {
    private final String registrationId;
    private final String assertionConsumerServiceUrlTemplate;
    private final List<Saml2X509Credential> credentials;
    private final String localEntityIdTemplate;
    private final ProviderDetails providerDetails;

    private RelyingPartyRegistration(String registrationId, String assertionConsumerServiceUrlTemplate, ProviderDetails providerDetails, List<Saml2X509Credential> credentials, String localEntityIdTemplate) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        Assert.hasText((String)assertionConsumerServiceUrlTemplate, (String)"assertionConsumerServiceUrlTemplate cannot be empty");
        Assert.hasText((String)localEntityIdTemplate, (String)"localEntityIdTemplate cannot be empty");
        Assert.notEmpty(credentials, (String)"credentials cannot be empty");
        Assert.notNull((Object)providerDetails, (String)"providerDetails cannot be null");
        Assert.hasText((String)providerDetails.webSsoUrl, (String)"providerDetails.webSsoUrl cannot be empty");
        for (Saml2X509Credential c : credentials) {
            Assert.notNull((Object)c, (String)"credentials cannot contain null elements");
        }
        this.registrationId = registrationId;
        this.assertionConsumerServiceUrlTemplate = assertionConsumerServiceUrlTemplate;
        this.credentials = Collections.unmodifiableList(new LinkedList<Saml2X509Credential>(credentials));
        this.providerDetails = providerDetails;
        this.localEntityIdTemplate = localEntityIdTemplate;
    }

    @Deprecated
    public String getRemoteIdpEntityId() {
        return this.providerDetails.getEntityId();
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public String getAssertionConsumerServiceUrlTemplate() {
        return this.assertionConsumerServiceUrlTemplate;
    }

    @Deprecated
    public String getIdpWebSsoUrl() {
        return this.getProviderDetails().webSsoUrl;
    }

    public ProviderDetails getProviderDetails() {
        return this.providerDetails;
    }

    public String getLocalEntityIdTemplate() {
        return this.localEntityIdTemplate;
    }

    public List<Saml2X509Credential> getCredentials() {
        return this.credentials;
    }

    public List<Saml2X509Credential> getVerificationCredentials() {
        return this.filterCredentials(c -> c.isSignatureVerficationCredential());
    }

    public List<Saml2X509Credential> getSigningCredentials() {
        return this.filterCredentials(c -> c.isSigningCredential());
    }

    public List<Saml2X509Credential> getEncryptionCredentials() {
        return this.filterCredentials(c -> c.isEncryptionCredential());
    }

    public List<Saml2X509Credential> getDecryptionCredentials() {
        return this.filterCredentials(c -> c.isDecryptionCredential());
    }

    private List<Saml2X509Credential> filterCredentials(Function<Saml2X509Credential, Boolean> filter) {
        LinkedList<Saml2X509Credential> result = new LinkedList<Saml2X509Credential>();
        for (Saml2X509Credential c : this.getCredentials()) {
            if (!filter.apply(c).booleanValue()) continue;
            result.add(c);
        }
        return result;
    }

    public static Builder withRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return new Builder(registrationId);
    }

    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        Assert.notNull((Object)registration, (String)"registration cannot be null");
        return RelyingPartyRegistration.withRegistrationId(registration.getRegistrationId()).providerDetails(c -> {
            c.webSsoUrl(registration.getProviderDetails().getWebSsoUrl());
            c.binding(registration.getProviderDetails().getBinding());
            c.signAuthNRequest(registration.getProviderDetails().isSignAuthNRequest());
            c.entityId(registration.getProviderDetails().getEntityId());
        }).credentials(c -> c.addAll(registration.getCredentials())).localEntityIdTemplate(registration.getLocalEntityIdTemplate()).assertionConsumerServiceUrlTemplate(registration.getAssertionConsumerServiceUrlTemplate());
    }

    public static final class Builder {
        private String registrationId;
        private String assertionConsumerServiceUrlTemplate;
        private List<Saml2X509Credential> credentials = new LinkedList<Saml2X509Credential>();
        private String localEntityIdTemplate = "{baseUrl}/saml2/service-provider-metadata/{registrationId}";
        private ProviderDetails.Builder providerDetails = new ProviderDetails.Builder();

        private Builder(String registrationId) {
            this.registrationId = registrationId;
        }

        public Builder registrationId(String id) {
            this.registrationId = id;
            return this;
        }

        @Deprecated
        public Builder remoteIdpEntityId(String entityId) {
            this.providerDetails(idp -> idp.entityId(entityId));
            return this;
        }

        public Builder assertionConsumerServiceUrlTemplate(String assertionConsumerServiceUrlTemplate) {
            this.assertionConsumerServiceUrlTemplate = assertionConsumerServiceUrlTemplate;
            return this;
        }

        @Deprecated
        public Builder idpWebSsoUrl(String url) {
            this.providerDetails(config -> config.webSsoUrl(url));
            return this;
        }

        public Builder providerDetails(Consumer<ProviderDetails.Builder> providerDetails) {
            providerDetails.accept(this.providerDetails);
            return this;
        }

        public Builder credentials(Consumer<Collection<Saml2X509Credential>> credentials) {
            credentials.accept(this.credentials);
            return this;
        }

        public Builder localEntityIdTemplate(String template) {
            this.localEntityIdTemplate = template;
            return this;
        }

        public RelyingPartyRegistration build() {
            return new RelyingPartyRegistration(this.registrationId, this.assertionConsumerServiceUrlTemplate, this.providerDetails.build(), this.credentials, this.localEntityIdTemplate);
        }
    }

    public static final class ProviderDetails {
        private final String entityId;
        private final String webSsoUrl;
        private final boolean signAuthNRequest;
        private final Saml2MessageBinding binding;

        private ProviderDetails(String entityId, String webSsoUrl, boolean signAuthNRequest, Saml2MessageBinding binding) {
            Assert.hasText((String)entityId, (String)"entityId cannot be null or empty");
            Assert.notNull((Object)webSsoUrl, (String)"webSsoUrl cannot be null");
            Assert.notNull((Object)((Object)binding), (String)"binding cannot be null");
            this.entityId = entityId;
            this.webSsoUrl = webSsoUrl;
            this.signAuthNRequest = signAuthNRequest;
            this.binding = binding;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getWebSsoUrl() {
            return this.webSsoUrl;
        }

        public boolean isSignAuthNRequest() {
            return this.signAuthNRequest;
        }

        public Saml2MessageBinding getBinding() {
            return this.binding;
        }

        public static final class Builder {
            private String entityId;
            private String webSsoUrl;
            private boolean signAuthNRequest = true;
            private Saml2MessageBinding binding = Saml2MessageBinding.REDIRECT;

            public Builder entityId(String entityId) {
                this.entityId = entityId;
                return this;
            }

            public Builder webSsoUrl(String url) {
                this.webSsoUrl = url;
                return this;
            }

            public Builder signAuthNRequest(boolean signAuthNRequest) {
                this.signAuthNRequest = signAuthNRequest;
                return this;
            }

            public Builder binding(Saml2MessageBinding binding) {
                this.binding = binding;
                return this;
            }

            public ProviderDetails build() {
                return new ProviderDetails(this.entityId, this.webSsoUrl, this.signAuthNRequest, this.binding);
            }
        }
    }
}

