/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.springframework.security.saml2.credentials.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlImplementation;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2Utils;
import org.springframework.util.Assert;

public class OpenSamlAuthenticationRequestFactory
implements Saml2AuthenticationRequestFactory {
    private Clock clock = Clock.systemUTC();
    private final OpenSamlImplementation saml = OpenSamlImplementation.getInstance();
    private String protocolBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";

    @Override
    @Deprecated
    public String createAuthenticationRequest(Saml2AuthenticationRequest request) {
        AuthnRequest authnRequest = this.createAuthnRequest(request.getIssuer(), request.getDestination(), request.getAssertionConsumerServiceUrl());
        return this.saml.serialize(authnRequest, request.getCredentials());
    }

    @Override
    public Saml2PostAuthenticationRequest createPostAuthenticationRequest(Saml2AuthenticationRequestContext context) {
        AuthnRequest authnRequest = this.createAuthnRequest(context);
        String xml = context.getRelyingPartyRegistration().getProviderDetails().isSignAuthNRequest() ? this.saml.serialize(authnRequest, context.getRelyingPartyRegistration().getSigningCredentials()) : this.saml.serialize((XMLObject)authnRequest);
        return ((Saml2PostAuthenticationRequest.Builder)Saml2PostAuthenticationRequest.withAuthenticationRequestContext(context).samlRequest(Saml2Utils.samlEncode(xml.getBytes(StandardCharsets.UTF_8)))).build();
    }

    @Override
    public Saml2RedirectAuthenticationRequest createRedirectAuthenticationRequest(Saml2AuthenticationRequestContext context) {
        AuthnRequest authnRequest = this.createAuthnRequest(context);
        String xml = this.saml.serialize((XMLObject)authnRequest);
        Saml2RedirectAuthenticationRequest.Builder result = Saml2RedirectAuthenticationRequest.withAuthenticationRequestContext(context);
        String deflatedAndEncoded = Saml2Utils.samlEncode(Saml2Utils.samlDeflate(xml));
        ((Saml2RedirectAuthenticationRequest.Builder)result.samlRequest(deflatedAndEncoded)).relayState(context.getRelayState());
        if (context.getRelyingPartyRegistration().getProviderDetails().isSignAuthNRequest()) {
            List<Saml2X509Credential> signingCredentials = context.getRelyingPartyRegistration().getSigningCredentials();
            Map<String, String> signedParams = this.saml.signQueryParameters(signingCredentials, deflatedAndEncoded, context.getRelayState());
            ((Saml2RedirectAuthenticationRequest.Builder)((Saml2RedirectAuthenticationRequest.Builder)result.samlRequest(signedParams.get("SAMLRequest"))).relayState(signedParams.get("RelayState"))).sigAlg(signedParams.get("SigAlg")).signature(signedParams.get("Signature"));
        }
        return result.build();
    }

    private AuthnRequest createAuthnRequest(Saml2AuthenticationRequestContext context) {
        return this.createAuthnRequest(context.getIssuer(), context.getDestination(), context.getAssertionConsumerServiceUrl());
    }

    private AuthnRequest createAuthnRequest(String issuer, String destination, String assertionConsumerServiceUrl) {
        AuthnRequest auth = (AuthnRequest)this.saml.buildSamlObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        auth.setID("ARQ" + UUID.randomUUID().toString().substring(1));
        auth.setIssueInstant(new DateTime(this.clock.millis()));
        auth.setForceAuthn(Boolean.FALSE);
        auth.setIsPassive(Boolean.FALSE);
        auth.setProtocolBinding(this.protocolBinding);
        Issuer iss = (Issuer)this.saml.buildSamlObject(Issuer.DEFAULT_ELEMENT_NAME);
        iss.setValue(issuer);
        auth.setIssuer(iss);
        auth.setDestination(destination);
        auth.setAssertionConsumerServiceURL(assertionConsumerServiceUrl);
        return auth;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    public void setProtocolBinding(String protocolBinding) {
        boolean isAllowedBinding;
        boolean bl = isAllowedBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(protocolBinding) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(protocolBinding);
        if (!isAllowedBinding) {
            throw new IllegalArgumentException("Invalid protocol binding: " + protocolBinding);
        }
        this.protocolBinding = protocolBinding;
    }
}

