/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2Error;
import org.springframework.util.Assert;

public class Saml2AuthenticationException
extends AuthenticationException {
    private Saml2Error error;

    public Saml2AuthenticationException(Saml2Error error) {
        this(error, error.getDescription());
    }

    public Saml2AuthenticationException(Saml2Error error, Throwable cause) {
        this(error, cause.getMessage(), cause);
    }

    public Saml2AuthenticationException(Saml2Error error, String message) {
        super(message);
        this.setError(error);
    }

    public Saml2AuthenticationException(Saml2Error error, String message, Throwable cause) {
        super(message, cause);
        this.setError(error);
    }

    public Saml2Error getError() {
        return this.error;
    }

    private void setError(Saml2Error error) {
        Assert.notNull((Object)error, (String)"error cannot be null");
        this.error = error;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Saml2AuthenticationException{");
        sb.append("error=").append(this.error);
        sb.append('}');
        return sb.toString();
    }
}

