/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.time.Clock;
import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlImplementation;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.util.Assert;

public class OpenSamlAuthenticationRequestFactory
implements Saml2AuthenticationRequestFactory {
    private Clock clock = Clock.systemUTC();
    private final OpenSamlImplementation saml = OpenSamlImplementation.getInstance();
    private String protocolBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";

    @Override
    public String createAuthenticationRequest(Saml2AuthenticationRequest request) {
        AuthnRequest auth = this.saml.buildSAMLObject(AuthnRequest.class);
        auth.setID("ARQ" + UUID.randomUUID().toString().substring(1));
        auth.setIssueInstant(new DateTime(this.clock.millis()));
        auth.setForceAuthn(Boolean.FALSE);
        auth.setIsPassive(Boolean.FALSE);
        auth.setProtocolBinding(this.protocolBinding);
        Issuer issuer = this.saml.buildSAMLObject(Issuer.class);
        issuer.setValue(request.getIssuer());
        auth.setIssuer(issuer);
        auth.setDestination(request.getDestination());
        auth.setAssertionConsumerServiceURL(request.getAssertionConsumerServiceUrl());
        return this.saml.toXml((XMLObject)auth, request.getCredentials(), request.getIssuer());
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    public void setProtocolBinding(String protocolBinding) {
        boolean isAllowedBinding;
        boolean bl = isAllowedBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(protocolBinding) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(protocolBinding);
        if (!isAllowedBinding) {
            throw new IllegalArgumentException("Invalid protocol binding: " + protocolBinding);
        }
        this.protocolBinding = protocolBinding;
    }
}

