/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.source.JWKSecurityContextJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWKSecurityContext;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JWSAlgorithmMapJWSKeySelector;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveRemoteJWKSource;
import org.springframework.security.oauth2.jwt.SingleKeyJWSKeySelector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NimbusReactiveJwtDecoder
implements ReactiveJwtDecoder {
    private final Converter<JWT, Mono<JWTClaimsSet>> jwtProcessor;
    private OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefault();
    private Converter<Map<String, Object>, Map<String, Object>> claimSetConverter = MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());

    public NimbusReactiveJwtDecoder(String jwkSetUrl) {
        this(NimbusReactiveJwtDecoder.withJwkSetUri(jwkSetUrl).processor());
    }

    public NimbusReactiveJwtDecoder(RSAPublicKey publicKey) {
        this(NimbusReactiveJwtDecoder.withPublicKey(publicKey).processor());
    }

    public NimbusReactiveJwtDecoder(Converter<JWT, Mono<JWTClaimsSet>> jwtProcessor) {
        this.jwtProcessor = jwtProcessor;
    }

    public void setJwtValidator(OAuth2TokenValidator<Jwt> jwtValidator) {
        Assert.notNull(jwtValidator, (String)"jwtValidator cannot be null");
        this.jwtValidator = jwtValidator;
    }

    public void setClaimSetConverter(Converter<Map<String, Object>, Map<String, Object>> claimSetConverter) {
        Assert.notNull(claimSetConverter, (String)"claimSetConverter cannot be null");
        this.claimSetConverter = claimSetConverter;
    }

    @Override
    public Mono<Jwt> decode(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof PlainJWT) {
            throw new JwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
        }
        return this.decode(jwt);
    }

    private JWT parse(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (Exception ex) {
            throw new JwtException("An error occurred while attempting to decode the Jwt: " + ex.getMessage(), ex);
        }
    }

    private Mono<Jwt> decode(JWT parsedToken) {
        try {
            return ((Mono)this.jwtProcessor.convert((Object)parsedToken)).map(set -> this.createJwt(parsedToken, (JWTClaimsSet)set)).map(this::validateJwt).onErrorMap(e -> !(e instanceof IllegalStateException) && !(e instanceof JwtException), e -> new JwtException("An error occurred while attempting to decode the Jwt: ", (Throwable)e));
        }
        catch (RuntimeException ex) {
            throw new JwtException("An error occurred while attempting to decode the Jwt: " + ex.getMessage(), ex);
        }
    }

    private Jwt createJwt(JWT parsedJwt, JWTClaimsSet jwtClaimsSet) {
        LinkedHashMap headers = new LinkedHashMap(parsedJwt.getHeader().toJSONObject());
        Map claims = (Map)this.claimSetConverter.convert((Object)jwtClaimsSet.getClaims());
        return Jwt.withTokenValue(parsedJwt.getParsedString()).headers(h -> h.putAll(headers)).claims(c -> c.putAll(claims)).build();
    }

    private Jwt validateJwt(Jwt jwt) {
        OAuth2TokenValidatorResult result = this.jwtValidator.validate((AbstractOAuth2Token)jwt);
        if (result.hasErrors()) {
            Collection errors = result.getErrors();
            String validationErrorString = "Unable to validate Jwt";
            for (OAuth2Error oAuth2Error : errors) {
                if (StringUtils.isEmpty((Object)oAuth2Error.getDescription())) continue;
                validationErrorString = oAuth2Error.getDescription();
                break;
            }
            throw new JwtValidationException(validationErrorString, errors);
        }
        return jwt;
    }

    public static JwkSetUriReactiveJwtDecoderBuilder withJwkSetUri(String jwkSetUri) {
        return new JwkSetUriReactiveJwtDecoderBuilder(jwkSetUri);
    }

    public static PublicKeyReactiveJwtDecoderBuilder withPublicKey(RSAPublicKey key) {
        return new PublicKeyReactiveJwtDecoderBuilder(key);
    }

    public static SecretKeyReactiveJwtDecoderBuilder withSecretKey(SecretKey secretKey) {
        return new SecretKeyReactiveJwtDecoderBuilder(secretKey);
    }

    public static JwkSourceReactiveJwtDecoderBuilder withJwkSource(Function<SignedJWT, Flux<JWK>> source) {
        return new JwkSourceReactiveJwtDecoderBuilder(source);
    }

    private static <C extends SecurityContext> JWTClaimsSet createClaimsSet(JWTProcessor<C> jwtProcessor, JWT parsedToken, C context) {
        try {
            return jwtProcessor.process(parsedToken, context);
        }
        catch (JOSEException | BadJOSEException e) {
            throw new JwtException("Failed to validate the token", e);
        }
    }

    public static final class JwkSourceReactiveJwtDecoderBuilder {
        private final Function<SignedJWT, Flux<JWK>> jwkSource;
        private JWSAlgorithm jwsAlgorithm = JWSAlgorithm.RS256;

        private JwkSourceReactiveJwtDecoderBuilder(Function<SignedJWT, Flux<JWK>> jwkSource) {
            Assert.notNull(jwkSource, (String)"jwkSource cannot be null");
            this.jwkSource = jwkSource;
        }

        public JwkSourceReactiveJwtDecoderBuilder jwsAlgorithm(JwsAlgorithm jwsAlgorithm) {
            Assert.notNull((Object)jwsAlgorithm, (String)"jwsAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)jwsAlgorithm.getName());
            return this;
        }

        public NimbusReactiveJwtDecoder build() {
            return new NimbusReactiveJwtDecoder(this.processor());
        }

        Converter<JWT, Mono<JWTClaimsSet>> processor() {
            JWKSecurityContextJWKSet jwkSource = new JWKSecurityContextJWKSet();
            JWSVerificationKeySelector jwsKeySelector = new JWSVerificationKeySelector(this.jwsAlgorithm, (JWKSource)jwkSource);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            return jwt -> {
                if (jwt instanceof SignedJWT) {
                    return this.jwkSource.apply((SignedJWT)jwt).onErrorMap(e -> new IllegalStateException("Could not obtain the keys", (Throwable)e)).collectList().map(jwks -> NimbusReactiveJwtDecoder.createClaimsSet((JWTProcessor)jwtProcessor, jwt, (SecurityContext)new JWKSecurityContext(jwks)));
                }
                throw new JwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
            };
        }
    }

    public static final class SecretKeyReactiveJwtDecoderBuilder {
        private final SecretKey secretKey;
        private JWSAlgorithm jwsAlgorithm = JWSAlgorithm.HS256;

        private SecretKeyReactiveJwtDecoderBuilder(SecretKey secretKey) {
            Assert.notNull((Object)secretKey, (String)"secretKey cannot be null");
            this.secretKey = secretKey;
        }

        public SecretKeyReactiveJwtDecoderBuilder macAlgorithm(MacAlgorithm macAlgorithm) {
            Assert.notNull((Object)macAlgorithm, (String)"macAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)macAlgorithm.getName());
            return this;
        }

        public NimbusReactiveJwtDecoder build() {
            return new NimbusReactiveJwtDecoder(this.processor());
        }

        Converter<JWT, Mono<JWTClaimsSet>> processor() {
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, this.secretKey);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            return jwt -> Mono.just((Object)NimbusReactiveJwtDecoder.createClaimsSet((JWTProcessor)jwtProcessor, jwt, null));
        }
    }

    public static final class PublicKeyReactiveJwtDecoderBuilder {
        private final RSAPublicKey key;
        private JWSAlgorithm jwsAlgorithm;

        private PublicKeyReactiveJwtDecoderBuilder(RSAPublicKey key) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            this.key = key;
            this.jwsAlgorithm = JWSAlgorithm.RS256;
        }

        public PublicKeyReactiveJwtDecoderBuilder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
            return this;
        }

        public NimbusReactiveJwtDecoder build() {
            return new NimbusReactiveJwtDecoder(this.processor());
        }

        Converter<JWT, Mono<JWTClaimsSet>> processor() {
            if (!JWSAlgorithm.Family.RSA.contains((Object)this.jwsAlgorithm)) {
                throw new IllegalStateException("The provided key is of type RSA; however the signature algorithm is of some other type: " + this.jwsAlgorithm + ". Please indicate one of RS256, RS384, or RS512.");
            }
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, this.key);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            return jwt -> Mono.just((Object)NimbusReactiveJwtDecoder.createClaimsSet((JWTProcessor)jwtProcessor, jwt, null));
        }
    }

    public static final class JwkSetUriReactiveJwtDecoderBuilder {
        private final String jwkSetUri;
        private Set<SignatureAlgorithm> signatureAlgorithms = new HashSet<SignatureAlgorithm>();
        private WebClient webClient = WebClient.create();

        private JwkSetUriReactiveJwtDecoderBuilder(String jwkSetUri) {
            Assert.hasText((String)jwkSetUri, (String)"jwkSetUri cannot be empty");
            this.jwkSetUri = jwkSetUri;
        }

        public JwkSetUriReactiveJwtDecoderBuilder jwsAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"sig cannot be null");
            this.signatureAlgorithms.add(signatureAlgorithm);
            return this;
        }

        public JwkSetUriReactiveJwtDecoderBuilder jwsAlgorithms(Consumer<Set<SignatureAlgorithm>> signatureAlgorithmsConsumer) {
            Assert.notNull(signatureAlgorithmsConsumer, (String)"signatureAlgorithmsConsumer cannot be null");
            signatureAlgorithmsConsumer.accept(this.signatureAlgorithms);
            return this;
        }

        public JwkSetUriReactiveJwtDecoderBuilder webClient(WebClient webClient) {
            Assert.notNull((Object)webClient, (String)"webClient cannot be null");
            this.webClient = webClient;
            return this;
        }

        public NimbusReactiveJwtDecoder build() {
            return new NimbusReactiveJwtDecoder(this.processor());
        }

        JWSKeySelector<JWKSecurityContext> jwsKeySelector(JWKSource<JWKSecurityContext> jwkSource) {
            if (this.signatureAlgorithms.isEmpty()) {
                return new JWSVerificationKeySelector(JWSAlgorithm.RS256, jwkSource);
            }
            if (this.signatureAlgorithms.size() == 1) {
                JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)this.signatureAlgorithms.iterator().next().getName());
                return new JWSVerificationKeySelector(jwsAlgorithm, jwkSource);
            }
            HashMap jwsKeySelectors = new HashMap();
            for (SignatureAlgorithm signatureAlgorithm : this.signatureAlgorithms) {
                JWSAlgorithm jwsAlg = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
                jwsKeySelectors.put(jwsAlg, new JWSVerificationKeySelector(jwsAlg, jwkSource));
            }
            return new JWSAlgorithmMapJWSKeySelector<JWKSecurityContext>(jwsKeySelectors);
        }

        Converter<JWT, Mono<JWTClaimsSet>> processor() {
            JWKSecurityContextJWKSet jwkSource = new JWKSecurityContextJWKSet();
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            JWSKeySelector<JWKSecurityContext> jwsKeySelector = this.jwsKeySelector((JWKSource<JWKSecurityContext>)jwkSource);
            jwtProcessor.setJWSKeySelector(jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            ReactiveRemoteJWKSource source = new ReactiveRemoteJWKSource(this.jwkSetUri);
            source.setWebClient(this.webClient);
            Set<JWSAlgorithm> expectedJwsAlgorithms = this.getExpectedJwsAlgorithms(jwsKeySelector);
            return jwt -> {
                JWKSelector selector = this.createSelector(expectedJwsAlgorithms, jwt.getHeader());
                return source.get(selector).onErrorMap(e -> new IllegalStateException("Could not obtain the keys", (Throwable)e)).map(jwkList -> NimbusReactiveJwtDecoder.createClaimsSet((JWTProcessor)jwtProcessor, jwt, (SecurityContext)new JWKSecurityContext(jwkList)));
            };
        }

        private Set<JWSAlgorithm> getExpectedJwsAlgorithms(JWSKeySelector<?> jwsKeySelector) {
            if (jwsKeySelector instanceof JWSVerificationKeySelector) {
                return Collections.singleton(((JWSVerificationKeySelector)jwsKeySelector).getExpectedJWSAlgorithm());
            }
            if (jwsKeySelector instanceof JWSAlgorithmMapJWSKeySelector) {
                return ((JWSAlgorithmMapJWSKeySelector)jwsKeySelector).getExpectedJWSAlgorithms();
            }
            throw new IllegalArgumentException("Unsupported key selector type " + jwsKeySelector.getClass());
        }

        private JWKSelector createSelector(Set<JWSAlgorithm> expectedJwsAlgorithms, Header header) {
            if (!expectedJwsAlgorithms.contains(header.getAlgorithm())) {
                throw new JwtException("Unsupported algorithm of " + header.getAlgorithm());
            }
            return new JWKSelector(JWKMatcher.forJWSHeader((JWSHeader)((JWSHeader)header)));
        }
    }
}

