/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.web.DefaultConsentPage;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeRequestAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationConsentAuthenticationConverter;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class OAuth2AuthorizationEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_AUTHORIZATION_ENDPOINT_URI = "/oauth2/authorize";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher authorizationEndpointMatcher;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationConverter authenticationConverter;
    private AuthenticationSuccessHandler authenticationSuccessHandler = this::sendAuthorizationResponse;
    private AuthenticationFailureHandler authenticationFailureHandler = this::sendErrorResponse;
    private SessionAuthenticationStrategy sessionAuthenticationStrategy = (authentication, request, response) -> {};
    private String consentPage;

    public OAuth2AuthorizationEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_AUTHORIZATION_ENDPOINT_URI);
    }

    public OAuth2AuthorizationEndpointFilter(AuthenticationManager authenticationManager, String authorizationEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)authorizationEndpointUri, (String)"authorizationEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.authorizationEndpointMatcher = OAuth2AuthorizationEndpointFilter.createDefaultRequestMatcher(authorizationEndpointUri);
        this.authenticationConverter = new DelegatingAuthenticationConverter(Arrays.asList(new OAuth2AuthorizationCodeRequestAuthenticationConverter(), new OAuth2AuthorizationConsentAuthenticationConverter()));
    }

    private static RequestMatcher createDefaultRequestMatcher(String authorizationEndpointUri) {
        PathPatternRequestMatcher authorizationRequestGetMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, authorizationEndpointUri);
        PathPatternRequestMatcher authorizationRequestPostMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, authorizationEndpointUri);
        RequestMatcher authorizationConsentMatcher = OAuth2AuthorizationEndpointFilter.createAuthorizationConsentMatcher(authorizationEndpointUri);
        OrRequestMatcher authorizationRequestMatcher = new OrRequestMatcher(new RequestMatcher[]{authorizationRequestGetMatcher, new AndRequestMatcher(new RequestMatcher[]{authorizationRequestPostMatcher, new NegatedRequestMatcher(authorizationConsentMatcher)})});
        return new OrRequestMatcher(new RequestMatcher[]{authorizationRequestMatcher, authorizationConsentMatcher});
    }

    private static RequestMatcher createAuthorizationConsentMatcher(String authorizationEndpointUri) {
        PathPatternRequestMatcher authorizationConsentPostMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, authorizationEndpointUri);
        return arg_0 -> OAuth2AuthorizationEndpointFilter.lambda$createAuthorizationConsentMatcher$1((RequestMatcher)authorizationConsentPostMatcher, arg_0);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.authorizationEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication authenticationResult;
            Authentication authentication = (Authentication)request.getAttribute(OAuth2AuthorizationCodeRequestAuthenticationToken.class.getName());
            if (authentication == null && (authentication = this.authenticationConverter.convert(request)) instanceof AbstractAuthenticationToken) {
                AbstractAuthenticationToken authenticationToken = (AbstractAuthenticationToken)authentication;
                authenticationToken.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            }
            if ((authenticationResult = this.authenticationManager.authenticate(authentication)) instanceof OAuth2AuthorizationConsentAuthenticationToken) {
                OAuth2AuthorizationConsentAuthenticationToken authorizationConsentAuthenticationToken = (OAuth2AuthorizationConsentAuthenticationToken)authenticationResult;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Authorization consent is required");
                }
                this.sendAuthorizationConsent(request, response, (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication, authorizationConsentAuthenticationToken);
                return;
            }
            this.sessionAuthenticationStrategy.onAuthentication(authenticationResult, request, response);
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, authenticationResult);
        }
        catch (OAuth2AuthenticationException ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Authorization request failed: %s", (Object)ex.getError()), (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
        }
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"authenticationDetailsSource cannot be null");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        Assert.notNull((Object)sessionAuthenticationStrategy, (String)"sessionAuthenticationStrategy cannot be null");
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy;
    }

    public void setConsentPage(String consentPage) {
        this.consentPage = consentPage;
    }

    private void sendAuthorizationConsent(HttpServletRequest request, HttpServletResponse response, OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication, OAuth2AuthorizationConsentAuthenticationToken authorizationConsentAuthentication) throws IOException {
        String clientId = authorizationConsentAuthentication.getClientId();
        Authentication principal = (Authentication)authorizationConsentAuthentication.getPrincipal();
        Set<String> authorizedScopes = authorizationConsentAuthentication.getScopes();
        String state = authorizationConsentAuthentication.getState();
        String requestUri = (String)authorizationCodeRequestAuthentication.getAdditionalParameters().get("request_uri");
        Set requestedScopes = StringUtils.hasText((String)requestUri) ? (Set)authorizationConsentAuthentication.getAdditionalParameters().get("scope") : authorizationCodeRequestAuthentication.getScopes();
        if (this.hasConsentUri()) {
            String redirectUri = UriComponentsBuilder.fromUriString((String)this.resolveConsentUri(request)).queryParam("scope", new Object[]{String.join((CharSequence)" ", requestedScopes)}).queryParam("client_id", new Object[]{clientId}).queryParam("state", new Object[]{state}).toUriString();
            this.redirectStrategy.sendRedirect(request, response, redirectUri);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Displaying generated consent screen");
            }
            DefaultConsentPage.displayConsent(request, response, clientId, principal, requestedScopes, authorizedScopes, state, Collections.emptyMap());
        }
    }

    private boolean hasConsentUri() {
        return StringUtils.hasText((String)this.consentPage);
    }

    private String resolveConsentUri(HttpServletRequest request) {
        if (UrlUtils.isAbsoluteUrl((String)this.consentPage)) {
            return this.consentPage;
        }
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(request.getScheme());
        urlBuilder.setServerName(request.getServerName());
        urlBuilder.setPort(request.getServerPort());
        urlBuilder.setContextPath(request.getContextPath());
        urlBuilder.setPathInfo(this.consentPage);
        return urlBuilder.getUrl();
    }

    private void sendAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("code", new Object[]{authorizationCodeRequestAuthentication.getAuthorizationCode().getTokenValue()});
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{UriUtils.encode((String)authorizationCodeRequestAuthentication.getState(), (Charset)StandardCharsets.UTF_8)});
        }
        String redirectUri = uriBuilder.build(true).toUriString();
        this.redirectStrategy.sendRedirect(request, response, redirectUri);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null || !StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
            response.sendError(HttpStatus.BAD_REQUEST.value(), error.toString());
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Redirecting to client with error");
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("error", new Object[]{error.getErrorCode()});
        if (StringUtils.hasText((String)error.getDescription())) {
            uriBuilder.queryParam("error_description", new Object[]{UriUtils.encode((String)error.getDescription(), (Charset)StandardCharsets.UTF_8)});
        }
        if (StringUtils.hasText((String)error.getUri())) {
            uriBuilder.queryParam("error_uri", new Object[]{UriUtils.encode((String)error.getUri(), (Charset)StandardCharsets.UTF_8)});
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{UriUtils.encode((String)authorizationCodeRequestAuthentication.getState(), (Charset)StandardCharsets.UTF_8)});
        }
        String redirectUri = uriBuilder.build(true).toUriString();
        this.redirectStrategy.sendRedirect(request, response, redirectUri);
    }

    Filter createAuthorizationCodeRequestValidatingFilter(RegisteredClientRepository registeredClientRepository, Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator) {
        return new OAuth2AuthorizationCodeRequestValidatingFilter(registeredClientRepository, authenticationValidator);
    }

    private static /* synthetic */ boolean lambda$createAuthorizationConsentMatcher$1(RequestMatcher authorizationConsentPostMatcher, HttpServletRequest request) {
        return authorizationConsentPostMatcher.matches(request) && request.getParameter("response_type") == null && request.getParameter("request_uri") == null && request.getParameter("redirect_uri") == null && request.getParameter("code_challenge") == null && request.getParameter("code_challenge_method") == null;
    }

    private final class OAuth2AuthorizationCodeRequestValidatingFilter
    extends OncePerRequestFilter {
        private final RegisteredClientRepository registeredClientRepository;
        private final Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator;
        private final Field setValidatedField;

        private OAuth2AuthorizationCodeRequestValidatingFilter(RegisteredClientRepository registeredClientRepository, Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator) {
            Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
            Assert.notNull(authenticationValidator, (String)"authenticationValidator cannot be null");
            this.registeredClientRepository = registeredClientRepository;
            this.authenticationValidator = authenticationValidator;
            this.setValidatedField = ReflectionUtils.findField(OAuth2AuthorizationCodeRequestAuthenticationToken.class, (String)"validated");
            ReflectionUtils.makeAccessible((Field)this.setValidatedField);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
            if (!OAuth2AuthorizationEndpointFilter.this.authorizationEndpointMatcher.matches(request)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            try {
                Authentication authentication = OAuth2AuthorizationEndpointFilter.this.authenticationConverter.convert(request);
                if (!(authentication instanceof OAuth2AuthorizationCodeRequestAuthenticationToken)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
                String requestUri = (String)authorizationCodeRequestAuthentication.getAdditionalParameters().get("request_uri");
                if (StringUtils.hasText((String)requestUri)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                authorizationCodeRequestAuthentication.setDetails(OAuth2AuthorizationEndpointFilter.this.authenticationDetailsSource.buildDetails((Object)request));
                RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(authorizationCodeRequestAuthentication.getClientId());
                if (registeredClient == null) {
                    String redirectUri = null;
                    OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthenticationResult = new OAuth2AuthorizationCodeRequestAuthenticationToken(authorizationCodeRequestAuthentication.getAuthorizationUri(), authorizationCodeRequestAuthentication.getClientId(), (Authentication)authorizationCodeRequestAuthentication.getPrincipal(), redirectUri, authorizationCodeRequestAuthentication.getState(), authorizationCodeRequestAuthentication.getScopes(), authorizationCodeRequestAuthentication.getAdditionalParameters());
                    OAuth2Error error = new OAuth2Error("invalid_request", "OAuth 2.0 Parameter: client_id", "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1");
                    throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, authorizationCodeRequestAuthenticationResult);
                }
                OAuth2AuthorizationCodeRequestAuthenticationContext authenticationContext = OAuth2AuthorizationCodeRequestAuthenticationContext.with(authorizationCodeRequestAuthentication).registeredClient(registeredClient).build();
                this.authenticationValidator.accept(authenticationContext);
                ReflectionUtils.setField((Field)this.setValidatedField, (Object)((Object)authorizationCodeRequestAuthentication), (Object)true);
                request.setAttribute(OAuth2AuthorizationCodeRequestAuthenticationToken.class.getName(), (Object)authorizationCodeRequestAuthentication);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (OAuth2AuthenticationException ex) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)LogMessage.format((String)"Authorization request failed: %s", (Object)ex.getError()), (Throwable)ex);
                }
                OAuth2AuthorizationEndpointFilter.this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
            }
            finally {
                request.removeAttribute(OAuth2AuthorizationCodeRequestAuthenticationToken.class.getName());
            }
        }
    }
}

