/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.server.authorization.AbstractOAuth2ClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientMetadataClaimAccessor;
import org.springframework.util.Assert;

public final class OidcClientRegistration
extends AbstractOAuth2ClientRegistration
implements OidcClientMetadataClaimAccessor {
    private static final long serialVersionUID = -8485448209864668396L;

    private OidcClientRegistration(Map<String, Object> claims) {
        super(claims);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withClaims(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        return (Builder)new Builder().claims(c -> c.putAll(claims));
    }

    public static final class Builder
    extends AbstractOAuth2ClientRegistration.AbstractBuilder<OidcClientRegistration, Builder> {
        private Builder() {
        }

        public Builder postLogoutRedirectUri(String postLogoutRedirectUri) {
            this.addClaimToClaimList("post_logout_redirect_uris", postLogoutRedirectUri);
            return this;
        }

        public Builder postLogoutRedirectUris(Consumer<List<String>> postLogoutRedirectUrisConsumer) {
            this.acceptClaimValues("post_logout_redirect_uris", postLogoutRedirectUrisConsumer);
            return this;
        }

        public Builder tokenEndpointAuthenticationSigningAlgorithm(String authenticationSigningAlgorithm) {
            return (Builder)this.claim("token_endpoint_auth_signing_alg", authenticationSigningAlgorithm);
        }

        public Builder idTokenSignedResponseAlgorithm(String idTokenSignedResponseAlgorithm) {
            return (Builder)this.claim("id_token_signed_response_alg", idTokenSignedResponseAlgorithm);
        }

        public Builder registrationAccessToken(String registrationAccessToken) {
            return (Builder)this.claim("registration_access_token", registrationAccessToken);
        }

        public Builder registrationClientUrl(String registrationClientUrl) {
            return (Builder)this.claim("registration_client_uri", registrationClientUrl);
        }

        @Override
        public OidcClientRegistration build() {
            this.validate();
            return new OidcClientRegistration(this.getClaims());
        }

        @Override
        protected void validate() {
            super.validate();
            Assert.notNull((Object)this.getClaims().get("redirect_uris"), (String)"redirect_uris cannot be null");
            Assert.isInstanceOf(List.class, (Object)this.getClaims().get("redirect_uris"), (String)"redirect_uris must be of type List");
            Assert.notEmpty((Collection)((List)this.getClaims().get("redirect_uris")), (String)"redirect_uris cannot be empty");
            if (this.getClaims().get("post_logout_redirect_uris") != null) {
                Assert.isInstanceOf(List.class, (Object)this.getClaims().get("post_logout_redirect_uris"), (String)"post_logout_redirect_uris must be of type List");
                Assert.notEmpty((Collection)((List)this.getClaims().get("post_logout_redirect_uris")), (String)"post_logout_redirect_uris cannot be empty");
            }
        }

        private void addClaimToClaimList(String name, String value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.getClaims().computeIfAbsent(name, k -> new LinkedList());
            ((List)this.getClaims().get(name)).add(value);
        }

        private void acceptClaimValues(String name, Consumer<List<String>> valuesConsumer) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull(valuesConsumer, (String)"valuesConsumer cannot be null");
            this.getClaims().computeIfAbsent(name, k -> new LinkedList());
            List values = (List)this.getClaims().get(name);
            valuesConsumer.accept(values);
        }
    }
}

