/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.OAuth2ClientRegistration;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.http.converter.OAuth2ClientRegistrationHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;

public final class OAuth2ClientRegistrationAuthenticationConverter
implements AuthenticationConverter {
    private final HttpMessageConverter<OAuth2ClientRegistration> clientRegistrationHttpMessageConverter = new OAuth2ClientRegistrationHttpMessageConverter();

    public Authentication convert(HttpServletRequest request) {
        OAuth2ClientRegistration clientRegistration;
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        try {
            clientRegistration = (OAuth2ClientRegistration)this.clientRegistrationHttpMessageConverter.read(OAuth2ClientRegistration.class, (HttpInputMessage)new ServletServerHttpRequest(request));
        }
        catch (Exception ex) {
            OAuth2Error error = new OAuth2Error("invalid_request", "OAuth 2.0 Client Registration Error: " + ex.getMessage(), "https://datatracker.ietf.org/doc/html/rfc7591#section-3.2.2");
            throw new OAuth2AuthenticationException(error, (Throwable)ex);
        }
        return new OAuth2ClientRegistrationAuthenticationToken(principal, clientRegistration);
    }
}

