/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class OAuth2DeviceVerificationAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -2164261941629756913L;
    private final Authentication principal;
    private final String userCode;
    private final Map<String, Object> additionalParameters;
    private final String clientId;

    public OAuth2DeviceVerificationAuthenticationToken(Authentication principal, String userCode, @Nullable Map<String, Object> additionalParameters) {
        super(Collections.emptyList());
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.hasText((String)userCode, (String)"userCode cannot be empty");
        this.principal = principal;
        this.userCode = userCode;
        this.additionalParameters = Collections.unmodifiableMap(additionalParameters != null ? new HashMap<String, Object>(additionalParameters) : Collections.emptyMap());
        this.clientId = null;
    }

    public OAuth2DeviceVerificationAuthenticationToken(Authentication principal, String userCode, String clientId) {
        super(Collections.emptyList());
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.hasText((String)userCode, (String)"userCode cannot be empty");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        this.principal = principal;
        this.userCode = userCode;
        this.clientId = clientId;
        this.additionalParameters = Collections.emptyMap();
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getUserCode() {
        return this.userCode;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public String getClientId() {
        return this.clientId;
    }
}

