/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2ClientRegistration;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.converter.OAuth2ClientRegistrationRegisteredClientConverter;
import org.springframework.security.oauth2.server.authorization.converter.RegisteredClientOAuth2ClientRegistrationConverter;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OAuth2ClientRegistrationAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc7591#section-3.2.2";
    private static final String DEFAULT_CLIENT_REGISTRATION_AUTHORIZED_SCOPE = "client.create";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private Converter<RegisteredClient, OAuth2ClientRegistration> clientRegistrationConverter;
    private Converter<OAuth2ClientRegistration, RegisteredClient> registeredClientConverter;
    private PasswordEncoder passwordEncoder;
    private boolean openRegistrationAllowed;

    public OAuth2ClientRegistrationAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.clientRegistrationConverter = new RegisteredClientOAuth2ClientRegistrationConverter();
        this.registeredClientConverter = new OAuth2ClientRegistrationRegisteredClientConverter();
        this.passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken;
        OAuth2ClientRegistrationAuthenticationToken clientRegistrationAuthentication = (OAuth2ClientRegistrationAuthenticationToken)authentication;
        AbstractOAuth2TokenAuthenticationToken accessTokenAuthentication = null;
        if (clientRegistrationAuthentication.getPrincipal() != null && AbstractOAuth2TokenAuthenticationToken.class.isAssignableFrom(clientRegistrationAuthentication.getPrincipal().getClass())) {
            accessTokenAuthentication = (AbstractOAuth2TokenAuthenticationToken)clientRegistrationAuthentication.getPrincipal();
        }
        if (accessTokenAuthentication == null) {
            if (this.openRegistrationAllowed) {
                return this.registerClient(clientRegistrationAuthentication, null);
            }
            throw new OAuth2AuthenticationException("invalid_token");
        }
        if (!accessTokenAuthentication.isAuthenticated()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        String accessTokenValue = accessTokenAuthentication.getToken().getTokenValue();
        OAuth2Authorization authorization = this.authorizationService.findByToken(accessTokenValue, OAuth2TokenType.ACCESS_TOKEN);
        if (authorization == null) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with initial access token");
        }
        if (!(authorizedAccessToken = authorization.getAccessToken()).isActive()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        OAuth2ClientRegistrationAuthenticationProvider.checkScope(authorizedAccessToken, Collections.singleton(DEFAULT_CLIENT_REGISTRATION_AUTHORIZED_SCOPE));
        return this.registerClient(clientRegistrationAuthentication, authorization);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2ClientRegistrationAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setRegisteredClientConverter(Converter<OAuth2ClientRegistration, RegisteredClient> registeredClientConverter) {
        Assert.notNull(registeredClientConverter, (String)"registeredClientConverter cannot be null");
        this.registeredClientConverter = registeredClientConverter;
    }

    public void setClientRegistrationConverter(Converter<RegisteredClient, OAuth2ClientRegistration> clientRegistrationConverter) {
        Assert.notNull(clientRegistrationConverter, (String)"clientRegistrationConverter cannot be null");
        this.clientRegistrationConverter = clientRegistrationConverter;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder cannot be null");
        this.passwordEncoder = passwordEncoder;
    }

    public void setOpenRegistrationAllowed(boolean openRegistrationAllowed) {
        this.openRegistrationAllowed = openRegistrationAllowed;
    }

    private OAuth2ClientRegistrationAuthenticationToken registerClient(OAuth2ClientRegistrationAuthenticationToken clientRegistrationAuthentication, OAuth2Authorization authorization) {
        RegisteredClient registeredClient;
        if (!OAuth2ClientRegistrationAuthenticationProvider.isValidRedirectUris(clientRegistrationAuthentication.getClientRegistration().getRedirectUris())) {
            OAuth2ClientRegistrationAuthenticationProvider.throwInvalidClientRegistration("invalid_redirect_uri", "redirect_uris");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated client registration request parameters");
        }
        if (StringUtils.hasText((String)(registeredClient = (RegisteredClient)this.registeredClientConverter.convert((Object)clientRegistrationAuthentication.getClientRegistration())).getClientSecret())) {
            RegisteredClient updatedRegisteredClient = RegisteredClient.from(registeredClient).clientSecret(this.passwordEncoder.encode((CharSequence)registeredClient.getClientSecret())).build();
            this.registeredClientRepository.save(updatedRegisteredClient);
            if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(clientRegistrationAuthentication.getClientRegistration().getTokenEndpointAuthenticationMethod())) {
                registeredClient = updatedRegisteredClient;
            }
        } else {
            this.registeredClientRepository.save(registeredClient);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved registered client");
        }
        if (authorization != null) {
            OAuth2Authorization.Builder builder = OAuth2Authorization.from(authorization).invalidate(authorization.getAccessToken().getToken());
            if (authorization.getRefreshToken() != null) {
                builder.invalidate(authorization.getRefreshToken().getToken());
            }
            authorization = builder.build();
            this.authorizationService.save(authorization);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Saved authorization with invalidated initial access token");
            }
        }
        OAuth2ClientRegistration clientRegistration = (OAuth2ClientRegistration)this.clientRegistrationConverter.convert((Object)registeredClient);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated client registration request");
        }
        OAuth2ClientRegistrationAuthenticationToken clientRegistrationAuthenticationResult = new OAuth2ClientRegistrationAuthenticationToken((Authentication)clientRegistrationAuthentication.getPrincipal(), clientRegistration);
        clientRegistrationAuthenticationResult.setDetails(clientRegistrationAuthentication.getDetails());
        return clientRegistrationAuthenticationResult;
    }

    private static void checkScope(OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken, Set<String> requiredScope) {
        Collection<Object> authorizedScope = Collections.emptySet();
        if (authorizedAccessToken.getClaims().containsKey("scope")) {
            authorizedScope = (Collection)authorizedAccessToken.getClaims().get("scope");
        }
        if (!authorizedScope.containsAll(requiredScope)) {
            throw new OAuth2AuthenticationException("insufficient_scope");
        }
        if (authorizedScope.size() != requiredScope.size()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
    }

    private static boolean isValidRedirectUris(List<String> redirectUris) {
        if (CollectionUtils.isEmpty(redirectUris)) {
            return true;
        }
        for (String redirectUri : redirectUris) {
            try {
                URI validRedirectUri = new URI(redirectUri);
                if (validRedirectUri.getFragment() == null) continue;
                return false;
            }
            catch (URISyntaxException ex) {
                return false;
            }
        }
        return true;
    }

    private static void throwInvalidClientRegistration(String errorCode, String fieldName) {
        OAuth2Error error = new OAuth2Error(errorCode, "Invalid Client Registration: " + fieldName, ERROR_URI);
        throw new OAuth2AuthenticationException(error);
    }
}

