/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.util.Assert;

public final class InMemoryOAuth2AuthorizationConsentService
implements OAuth2AuthorizationConsentService {
    private final Map<Integer, OAuth2AuthorizationConsent> authorizationConsents = new ConcurrentHashMap<Integer, OAuth2AuthorizationConsent>();

    public InMemoryOAuth2AuthorizationConsentService() {
        this(Collections.emptyList());
    }

    public InMemoryOAuth2AuthorizationConsentService(OAuth2AuthorizationConsent ... authorizationConsents) {
        this(Arrays.asList(authorizationConsents));
    }

    public InMemoryOAuth2AuthorizationConsentService(List<OAuth2AuthorizationConsent> authorizationConsents) {
        Assert.notNull(authorizationConsents, (String)"authorizationConsents cannot be null");
        authorizationConsents.forEach(authorizationConsent -> {
            Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
            int id = InMemoryOAuth2AuthorizationConsentService.getId(authorizationConsent);
            Assert.isTrue((!this.authorizationConsents.containsKey(id) ? 1 : 0) != 0, (String)("The authorizationConsent must be unique. Found duplicate, with registered client id: [" + authorizationConsent.getRegisteredClientId() + "] and principal name: [" + authorizationConsent.getPrincipalName() + "]"));
            this.authorizationConsents.put(id, (OAuth2AuthorizationConsent)authorizationConsent);
        });
    }

    @Override
    public void save(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
        int id = InMemoryOAuth2AuthorizationConsentService.getId(authorizationConsent);
        this.authorizationConsents.put(id, authorizationConsent);
    }

    @Override
    public void remove(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
        int id = InMemoryOAuth2AuthorizationConsentService.getId(authorizationConsent);
        this.authorizationConsents.remove(id, authorizationConsent);
    }

    @Override
    @Nullable
    public OAuth2AuthorizationConsent findById(String registeredClientId, String principalName) {
        Assert.hasText((String)registeredClientId, (String)"registeredClientId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        int id = InMemoryOAuth2AuthorizationConsentService.getId(registeredClientId, principalName);
        return this.authorizationConsents.get(id);
    }

    private static int getId(String registeredClientId, String principalName) {
        return Objects.hash(registeredClientId, principalName);
    }

    private static int getId(OAuth2AuthorizationConsent authorizationConsent) {
        return InMemoryOAuth2AuthorizationConsentService.getId(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName());
    }
}

