/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.util.Assert;

public class OidcLogoutAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 4001993612314913888L;
    private final String idTokenHint;
    private final OidcIdToken idToken;
    private final Authentication principal;
    private final String sessionId;
    private final String clientId;
    private final String postLogoutRedirectUri;
    private final String state;

    public OidcLogoutAuthenticationToken(String idTokenHint, Authentication principal, @Nullable String sessionId, @Nullable String clientId, @Nullable String postLogoutRedirectUri, @Nullable String state) {
        super(Collections.emptyList());
        Assert.hasText((String)idTokenHint, (String)"idTokenHint cannot be empty");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        this.idTokenHint = idTokenHint;
        this.idToken = null;
        this.principal = principal;
        this.sessionId = sessionId;
        this.clientId = clientId;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
        this.state = state;
        this.setAuthenticated(false);
    }

    public OidcLogoutAuthenticationToken(OidcIdToken idToken, Authentication principal, @Nullable String sessionId, @Nullable String clientId, @Nullable String postLogoutRedirectUri, @Nullable String state) {
        super(Collections.emptyList());
        Assert.notNull((Object)idToken, (String)"idToken cannot be null");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        this.idTokenHint = idToken.getTokenValue();
        this.idToken = idToken;
        this.principal = principal;
        this.sessionId = sessionId;
        this.clientId = clientId;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
        this.state = state;
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean isPrincipalAuthenticated() {
        return !AnonymousAuthenticationToken.class.isAssignableFrom(this.principal.getClass()) && this.principal.isAuthenticated();
    }

    public Object getCredentials() {
        return "";
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    @Nullable
    public OidcIdToken getIdToken() {
        return this.idToken;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    @Nullable
    public String getState() {
        return this.state;
    }
}

