/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.settings;

import java.util.Map;
import org.springframework.security.oauth2.server.authorization.settings.AbstractSettings;
import org.springframework.security.oauth2.server.authorization.settings.ConfigurationSettingNames;
import org.springframework.util.Assert;

public final class AuthorizationServerSettings
extends AbstractSettings {
    private static final long serialVersionUID = 2719834789442554660L;

    private AuthorizationServerSettings(Map<String, Object> settings) {
        super(settings);
    }

    public String getIssuer() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.ISSUER);
    }

    public boolean isMultipleIssuersAllowed() {
        return (Boolean)this.getSetting(ConfigurationSettingNames.AuthorizationServer.MULTIPLE_ISSUERS_ALLOWED);
    }

    public String getAuthorizationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.AUTHORIZATION_ENDPOINT);
    }

    public String getPushedAuthorizationRequestEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.PUSHED_AUTHORIZATION_REQUEST_ENDPOINT);
    }

    public String getDeviceAuthorizationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.DEVICE_AUTHORIZATION_ENDPOINT);
    }

    public String getDeviceVerificationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.DEVICE_VERIFICATION_ENDPOINT);
    }

    public String getTokenEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.TOKEN_ENDPOINT);
    }

    public String getJwkSetEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.JWK_SET_ENDPOINT);
    }

    public String getTokenRevocationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.TOKEN_REVOCATION_ENDPOINT);
    }

    public String getTokenIntrospectionEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.TOKEN_INTROSPECTION_ENDPOINT);
    }

    public String getClientRegistrationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.CLIENT_REGISTRATION_ENDPOINT);
    }

    public String getOidcClientRegistrationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.OIDC_CLIENT_REGISTRATION_ENDPOINT);
    }

    public String getOidcUserInfoEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.OIDC_USER_INFO_ENDPOINT);
    }

    public String getOidcLogoutEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.OIDC_LOGOUT_ENDPOINT);
    }

    public static Builder builder() {
        return new Builder().multipleIssuersAllowed(false).authorizationEndpoint("/oauth2/authorize").pushedAuthorizationRequestEndpoint("/oauth2/par").deviceAuthorizationEndpoint("/oauth2/device_authorization").deviceVerificationEndpoint("/oauth2/device_verification").tokenEndpoint("/oauth2/token").jwkSetEndpoint("/oauth2/jwks").tokenRevocationEndpoint("/oauth2/revoke").tokenIntrospectionEndpoint("/oauth2/introspect").clientRegistrationEndpoint("/oauth2/register").oidcClientRegistrationEndpoint("/connect/register").oidcUserInfoEndpoint("/userinfo").oidcLogoutEndpoint("/connect/logout");
    }

    public static Builder withSettings(Map<String, Object> settings) {
        Assert.notEmpty(settings, (String)"settings cannot be empty");
        return (Builder)new Builder().settings(s -> s.putAll(settings));
    }

    public static final class Builder
    extends AbstractSettings.AbstractBuilder<AuthorizationServerSettings, Builder> {
        private Builder() {
        }

        public Builder issuer(String issuer) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.ISSUER, issuer);
        }

        public Builder multipleIssuersAllowed(boolean multipleIssuersAllowed) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.MULTIPLE_ISSUERS_ALLOWED, multipleIssuersAllowed);
        }

        public Builder authorizationEndpoint(String authorizationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.AUTHORIZATION_ENDPOINT, authorizationEndpoint);
        }

        public Builder pushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.PUSHED_AUTHORIZATION_REQUEST_ENDPOINT, pushedAuthorizationRequestEndpoint);
        }

        public Builder deviceAuthorizationEndpoint(String deviceAuthorizationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.DEVICE_AUTHORIZATION_ENDPOINT, deviceAuthorizationEndpoint);
        }

        public Builder deviceVerificationEndpoint(String deviceVerificationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.DEVICE_VERIFICATION_ENDPOINT, deviceVerificationEndpoint);
        }

        public Builder tokenEndpoint(String tokenEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.TOKEN_ENDPOINT, tokenEndpoint);
        }

        public Builder jwkSetEndpoint(String jwkSetEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.JWK_SET_ENDPOINT, jwkSetEndpoint);
        }

        public Builder tokenRevocationEndpoint(String tokenRevocationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.TOKEN_REVOCATION_ENDPOINT, tokenRevocationEndpoint);
        }

        public Builder tokenIntrospectionEndpoint(String tokenIntrospectionEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.TOKEN_INTROSPECTION_ENDPOINT, tokenIntrospectionEndpoint);
        }

        public Builder clientRegistrationEndpoint(String clientRegistrationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.CLIENT_REGISTRATION_ENDPOINT, clientRegistrationEndpoint);
        }

        public Builder oidcClientRegistrationEndpoint(String oidcClientRegistrationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.OIDC_CLIENT_REGISTRATION_ENDPOINT, oidcClientRegistrationEndpoint);
        }

        public Builder oidcUserInfoEndpoint(String oidcUserInfoEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.OIDC_USER_INFO_ENDPOINT, oidcUserInfoEndpoint);
        }

        public Builder oidcLogoutEndpoint(String oidcLogoutEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.OIDC_LOGOUT_ENDPOINT, oidcLogoutEndpoint);
        }

        @Override
        public AuthorizationServerSettings build() {
            AuthorizationServerSettings authorizationServerSettings = new AuthorizationServerSettings(this.getSettings());
            if (authorizationServerSettings.getIssuer() != null && authorizationServerSettings.isMultipleIssuersAllowed()) {
                throw new IllegalArgumentException("The issuer identifier (" + authorizationServerSettings.getIssuer() + ") cannot be set when isMultipleIssuersAllowed() is true.");
            }
            return authorizationServerSettings;
        }
    }
}

