/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationContext;
import org.springframework.util.Assert;

public final class OAuth2AccessTokenAuthenticationContext
implements OAuth2AuthenticationContext {
    private final Map<Object, Object> context;

    private OAuth2AccessTokenAuthenticationContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public OAuth2AccessTokenResponse.Builder getAccessTokenResponse() {
        return this.get(OAuth2AccessTokenResponse.Builder.class);
    }

    public static Builder with(OAuth2AccessTokenAuthenticationToken authentication) {
        return new Builder(authentication);
    }

    public static final class Builder
    extends OAuth2AuthenticationContext.AbstractBuilder<OAuth2AccessTokenAuthenticationContext, Builder> {
        private Builder(OAuth2AccessTokenAuthenticationToken authentication) {
            super((Authentication)authentication);
        }

        public Builder accessTokenResponse(OAuth2AccessTokenResponse.Builder accessTokenResponse) {
            return (Builder)this.put(OAuth2AccessTokenResponse.Builder.class, accessTokenResponse);
        }

        @Override
        public OAuth2AccessTokenAuthenticationContext build() {
            Assert.notNull(this.get(OAuth2AccessTokenResponse.Builder.class), (String)"accessTokenResponse cannot be null");
            return new OAuth2AccessTokenAuthenticationContext(this.getContext());
        }
    }
}

