/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenIntrospection;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenIntrospectionAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2TokenIntrospectionAuthenticationProvider
implements AuthenticationProvider {
    private static final TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
    private static final TypeDescriptor LIST_STRING_TYPE_DESCRIPTOR = TypeDescriptor.collection(List.class, (TypeDescriptor)TypeDescriptor.valueOf(String.class));
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;

    public OAuth2TokenIntrospectionAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2Authorization.Token<OAuth2Token> authorizedToken;
        OAuth2TokenIntrospectionAuthenticationToken tokenIntrospectionAuthentication = (OAuth2TokenIntrospectionAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient((Authentication)tokenIntrospectionAuthentication);
        OAuth2Authorization authorization = this.authorizationService.findByToken(tokenIntrospectionAuthentication.getToken(), null);
        if (authorization == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Did not authenticate token introspection request since token was not found");
            }
            return tokenIntrospectionAuthentication;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with token");
        }
        if (!(authorizedToken = authorization.getToken(tokenIntrospectionAuthentication.getToken())).isActive()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Did not introspect token since not active");
            }
            return new OAuth2TokenIntrospectionAuthenticationToken(tokenIntrospectionAuthentication.getToken(), (Authentication)clientPrincipal, OAuth2TokenIntrospection.builder().build());
        }
        RegisteredClient authorizedClient = this.registeredClientRepository.findById(authorization.getRegisteredClientId());
        OAuth2TokenIntrospection tokenClaims = OAuth2TokenIntrospectionAuthenticationProvider.withActiveTokenClaims(authorizedToken, authorizedClient);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated token introspection request");
        }
        OAuth2TokenIntrospectionAuthenticationToken tokenIntrospectionAuthenticationResult = new OAuth2TokenIntrospectionAuthenticationToken(authorizedToken.getToken().getTokenValue(), (Authentication)clientPrincipal, tokenClaims);
        tokenIntrospectionAuthenticationResult.setDetails(tokenIntrospectionAuthentication.getDetails());
        return tokenIntrospectionAuthenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2TokenIntrospectionAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private static OAuth2TokenIntrospection withActiveTokenClaims(OAuth2Authorization.Token<OAuth2Token> authorizedToken, RegisteredClient authorizedClient) {
        OAuth2TokenIntrospection.Builder tokenClaims;
        if (!CollectionUtils.isEmpty(authorizedToken.getClaims())) {
            Map<String, Object> claims = OAuth2TokenIntrospectionAuthenticationProvider.convertClaimsIfNecessary(authorizedToken.getClaims());
            tokenClaims = OAuth2TokenIntrospection.withClaims(claims).active(true);
        } else {
            tokenClaims = OAuth2TokenIntrospection.builder(true);
        }
        tokenClaims.clientId(authorizedClient.getClientId());
        OAuth2Token token = authorizedToken.getToken();
        if (token.getIssuedAt() != null) {
            tokenClaims.issuedAt(token.getIssuedAt());
        }
        if (token.getExpiresAt() != null) {
            tokenClaims.expiresAt(token.getExpiresAt());
        }
        if (OAuth2AccessToken.class.isAssignableFrom(token.getClass())) {
            OAuth2AccessToken accessToken = (OAuth2AccessToken)token;
            tokenClaims.tokenType(accessToken.getTokenType().getValue());
        }
        return tokenClaims.build();
    }

    private static Map<String, Object> convertClaimsIfNecessary(Map<String, Object> claims) {
        Object convertedValue;
        HashMap<String, Object> convertedClaims = new HashMap<String, Object>(claims);
        Object value = claims.get("iss");
        if (value != null && !(value instanceof URL) && (convertedValue = (URL)ClaimConversionService.getSharedInstance().convert(value, URL.class)) != null) {
            convertedClaims.put("iss", convertedValue);
        }
        if ((value = claims.get("scope")) != null && !(value instanceof List) && (convertedValue = ClaimConversionService.getSharedInstance().convert(value, OBJECT_TYPE_DESCRIPTOR, LIST_STRING_TYPE_DESCRIPTOR)) != null) {
            convertedClaims.put("scope", convertedValue);
        }
        if ((value = claims.get("aud")) != null && !(value instanceof List) && (convertedValue = ClaimConversionService.getSharedInstance().convert(value, OBJECT_TYPE_DESCRIPTOR, LIST_STRING_TYPE_DESCRIPTOR)) != null) {
            convertedClaims.put("aud", convertedValue);
        }
        return convertedClaims;
    }
}

