/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.oidc.OidcProviderConfiguration;
import org.springframework.security.oauth2.server.authorization.oidc.http.converter.OidcProviderConfigurationHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OidcProviderConfigurationEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OIDC_PROVIDER_CONFIGURATION_ENDPOINT_URI = "/.well-known/openid-configuration";
    private final RequestMatcher requestMatcher = OidcProviderConfigurationEndpointFilter.createRequestMatcher();
    private final OidcProviderConfigurationHttpMessageConverter providerConfigurationHttpMessageConverter = new OidcProviderConfigurationHttpMessageConverter();
    private Consumer<OidcProviderConfiguration.Builder> providerConfigurationCustomizer = providerConfiguration -> {};

    public void setProviderConfigurationCustomizer(Consumer<OidcProviderConfiguration.Builder> providerConfigurationCustomizer) {
        Assert.notNull(providerConfigurationCustomizer, (String)"providerConfigurationCustomizer cannot be null");
        this.providerConfigurationCustomizer = providerConfigurationCustomizer;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
        String issuer = authorizationServerContext.getIssuer();
        AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
        OidcProviderConfiguration.Builder providerConfiguration = (OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)((OidcProviderConfiguration.Builder)OidcProviderConfiguration.builder().issuer(issuer)).authorizationEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getAuthorizationEndpoint()))).pushedAuthorizationRequestEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getPushedAuthorizationRequestEndpoint()))).deviceAuthorizationEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getDeviceAuthorizationEndpoint()))).tokenEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getTokenEndpoint()))).tokenEndpointAuthenticationMethods((Consumer)OidcProviderConfigurationEndpointFilter.clientAuthenticationMethods())).jwkSetUrl(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getJwkSetEndpoint()))).userInfoEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getOidcUserInfoEndpoint())).endSessionEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getOidcLogoutEndpoint())).responseType(OAuth2AuthorizationResponseType.CODE.getValue())).grantType(AuthorizationGrantType.AUTHORIZATION_CODE.getValue())).grantType(AuthorizationGrantType.CLIENT_CREDENTIALS.getValue())).grantType(AuthorizationGrantType.REFRESH_TOKEN.getValue())).grantType(AuthorizationGrantType.DEVICE_CODE.getValue())).grantType(AuthorizationGrantType.TOKEN_EXCHANGE.getValue())).tokenRevocationEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getTokenRevocationEndpoint()))).tokenRevocationEndpointAuthenticationMethods((Consumer)OidcProviderConfigurationEndpointFilter.clientAuthenticationMethods())).tokenIntrospectionEndpoint(OidcProviderConfigurationEndpointFilter.asUrl(issuer, authorizationServerSettings.getTokenIntrospectionEndpoint()))).tokenIntrospectionEndpointAuthenticationMethods((Consumer)OidcProviderConfigurationEndpointFilter.clientAuthenticationMethods())).codeChallengeMethod("S256")).tlsClientCertificateBoundAccessTokens(true)).dPoPSigningAlgorithms((Consumer)OidcProviderConfigurationEndpointFilter.dPoPSigningAlgorithms())).subjectType("public").idTokenSigningAlgorithm(SignatureAlgorithm.RS256.getName()).scope("openid");
        this.providerConfigurationCustomizer.accept(providerConfiguration);
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.providerConfigurationHttpMessageConverter.write(providerConfiguration.build(), MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
    }

    private static RequestMatcher createRequestMatcher() {
        PathPatternRequestMatcher defaultRequestMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, DEFAULT_OIDC_PROVIDER_CONFIGURATION_ENDPOINT_URI);
        PathPatternRequestMatcher multipleIssuersRequestMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, "/**/.well-known/openid-configuration");
        return arg_0 -> OidcProviderConfigurationEndpointFilter.lambda$createRequestMatcher$1((RequestMatcher)multipleIssuersRequestMatcher, (RequestMatcher)defaultRequestMatcher, arg_0);
    }

    private static Consumer<List<String>> clientAuthenticationMethods() {
        return authenticationMethods -> {
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.TLS_CLIENT_AUTH.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH.getValue());
        };
    }

    private static Consumer<List<String>> dPoPSigningAlgorithms() {
        return algs -> {
            algs.add("RS256");
            algs.add("RS384");
            algs.add("RS512");
            algs.add("PS256");
            algs.add("PS384");
            algs.add("PS512");
            algs.add("ES256");
            algs.add("ES384");
            algs.add("ES512");
        };
    }

    private static String asUrl(String issuer, String endpoint) {
        return UriComponentsBuilder.fromUriString((String)issuer).path(endpoint).build().toUriString();
    }

    private static /* synthetic */ boolean lambda$createRequestMatcher$1(RequestMatcher multipleIssuersRequestMatcher, RequestMatcher defaultRequestMatcher, HttpServletRequest request) {
        return AuthorizationServerContextHolder.getContext().getAuthorizationServerSettings().isMultipleIssuersAllowed() ? multipleIssuersRequestMatcher.matches(request) : defaultRequestMatcher.matches(request);
    }
}

