/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class RequestMatcherUtils {
    private RequestMatcherUtils() {
    }

    public static RequestMatcher matcher(String pattern, HttpMethod httpMethod) {
        Assert.hasText((String)pattern, (String)"pattern cannot be empty");
        Assert.notNull((Object)httpMethod, (String)"httpMethod cannot be null");
        return RequestMatcherUtils.containsMultipleIssuersPattern(pattern) ? new AntPathRequestMatcher(pattern, httpMethod) : PathPatternRequestMatcher.withDefaults().matcher(httpMethod, pattern);
    }

    public static String withMultipleIssuersPattern(String pattern) {
        Assert.hasText((String)pattern, (String)"pattern cannot be empty");
        return pattern.startsWith("/") ? "/**" + pattern : "/**/" + pattern;
    }

    private static boolean containsMultipleIssuersPattern(String pattern) {
        return pattern.startsWith("/**/");
    }

    private static final class AntPathRequestMatcher
    implements RequestMatcher {
        private final AntPathMatcher matcher = new AntPathMatcher();
        private final String pattern;
        private final HttpMethod httpMethod;

        private AntPathRequestMatcher(String pattern, HttpMethod httpMethod) {
            this.pattern = pattern;
            this.httpMethod = httpMethod;
        }

        public boolean matches(HttpServletRequest request) {
            if (StringUtils.hasText((String)request.getMethod()) && this.httpMethod != HttpMethod.valueOf((String)request.getMethod())) {
                return false;
            }
            String requestPath = AntPathRequestMatcher.getRequestPath(request);
            return this.matcher.match(this.pattern, requestPath);
        }

        private static String getRequestPath(HttpServletRequest request) {
            String url = request.getServletPath();
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                url = StringUtils.hasLength((String)url) ? url + pathInfo : pathInfo;
            }
            return url;
        }
    }
}

