/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeActor;
import org.springframework.util.Assert;

public class OAuth2TokenExchangeCompositeAuthenticationToken
extends AbstractAuthenticationToken {
    private final Authentication subject;
    private final List<OAuth2TokenExchangeActor> actors;

    public OAuth2TokenExchangeCompositeAuthenticationToken(Authentication subject, List<OAuth2TokenExchangeActor> actors) {
        super(subject != null ? subject.getAuthorities() : null);
        Assert.notNull((Object)subject, (String)"subject cannot be null");
        Assert.notNull(actors, (String)"actors cannot be null");
        this.subject = subject;
        this.actors = Collections.unmodifiableList(new ArrayList<OAuth2TokenExchangeActor>(actors));
        this.setDetails(subject.getDetails());
        this.setAuthenticated(subject.isAuthenticated());
    }

    public Object getPrincipal() {
        return this.subject.getPrincipal();
    }

    public Object getCredentials() {
        return null;
    }

    public Authentication getSubject() {
        return this.subject;
    }

    public List<OAuth2TokenExchangeActor> getActors() {
        return this.actors;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OAuth2TokenExchangeCompositeAuthenticationToken)) {
            return false;
        }
        OAuth2TokenExchangeCompositeAuthenticationToken other = (OAuth2TokenExchangeCompositeAuthenticationToken)((Object)obj);
        return super.equals(obj) && Objects.equals(this.subject, other.subject) && Objects.equals(this.actors, other.actors);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subject, this.actors);
    }
}

