/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationValidator;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2PushedAuthorizationRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2PushedAuthorizationRequestUri;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public final class OAuth2PushedAuthorizationRequestAuthenticationProvider
implements AuthenticationProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final OAuth2AuthorizationService authorizationService;
    private Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator = new OAuth2AuthorizationCodeRequestAuthenticationValidator();

    public OAuth2PushedAuthorizationRequestAuthenticationProvider(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.authorizationService = authorizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2PushedAuthorizationRequestAuthenticationToken pushedAuthorizationRequestAuthentication = (OAuth2PushedAuthorizationRequestAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient((Authentication)pushedAuthorizationRequestAuthentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        OAuth2AuthorizationCodeRequestAuthenticationContext authenticationContext = OAuth2AuthorizationCodeRequestAuthenticationContext.with(OAuth2PushedAuthorizationRequestAuthenticationProvider.toAuthorizationCodeRequestAuthentication(pushedAuthorizationRequestAuthentication)).registeredClient(registeredClient).build();
        OAuth2AuthorizationCodeRequestAuthenticationValidator.DEFAULT_AUTHORIZATION_GRANT_TYPE_VALIDATOR.accept(authenticationContext);
        this.authenticationValidator.accept(authenticationContext);
        OAuth2AuthorizationCodeRequestAuthenticationValidator.DEFAULT_CODE_CHALLENGE_VALIDATOR.accept(authenticationContext);
        OAuth2AuthorizationCodeRequestAuthenticationValidator.DEFAULT_PROMPT_VALIDATOR.accept(authenticationContext);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated pushed authorization request parameters");
        }
        OAuth2AuthorizationRequest authorizationRequest = OAuth2AuthorizationRequest.authorizationCode().authorizationUri(pushedAuthorizationRequestAuthentication.getAuthorizationUri()).clientId(registeredClient.getClientId()).redirectUri(pushedAuthorizationRequestAuthentication.getRedirectUri()).scopes(pushedAuthorizationRequestAuthentication.getScopes()).state(pushedAuthorizationRequestAuthentication.getState()).additionalParameters(pushedAuthorizationRequestAuthentication.getAdditionalParameters()).build();
        OAuth2PushedAuthorizationRequestUri pushedAuthorizationRequestUri = OAuth2PushedAuthorizationRequestUri.create();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Generated pushed authorization request uri");
        }
        OAuth2Authorization authorization = OAuth2Authorization.withRegisteredClient(registeredClient).principalName(clientPrincipal.getName()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).attribute(OAuth2AuthorizationRequest.class.getName(), authorizationRequest).attribute("state", pushedAuthorizationRequestUri.getState()).build();
        this.authorizationService.save(authorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated pushed authorization request");
        }
        return new OAuth2PushedAuthorizationRequestAuthenticationToken(authorizationRequest.getAuthorizationUri(), authorizationRequest.getClientId(), (Authentication)clientPrincipal, pushedAuthorizationRequestUri.getRequestUri(), pushedAuthorizationRequestUri.getExpiresAt(), authorizationRequest.getRedirectUri(), authorizationRequest.getState(), authorizationRequest.getScopes());
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2PushedAuthorizationRequestAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setAuthenticationValidator(Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> authenticationValidator) {
        Assert.notNull(authenticationValidator, (String)"authenticationValidator cannot be null");
        this.authenticationValidator = authenticationValidator;
    }

    private static OAuth2AuthorizationCodeRequestAuthenticationToken toAuthorizationCodeRequestAuthentication(OAuth2PushedAuthorizationRequestAuthenticationToken pushedAuthorizationCodeRequestAuthentication) {
        return new OAuth2AuthorizationCodeRequestAuthenticationToken(pushedAuthorizationCodeRequestAuthentication.getAuthorizationUri(), pushedAuthorizationCodeRequestAuthentication.getClientId(), (Authentication)pushedAuthorizationCodeRequestAuthentication.getPrincipal(), pushedAuthorizationCodeRequestAuthentication.getRedirectUri(), pushedAuthorizationCodeRequestAuthentication.getState(), pushedAuthorizationCodeRequestAuthentication.getScopes(), pushedAuthorizationCodeRequestAuthentication.getAdditionalParameters());
    }
}

