/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.util.Assert;

public class OAuth2TokenExchangeAuthenticationToken
extends OAuth2AuthorizationGrantAuthenticationToken {
    private final String requestedTokenType;
    private final String subjectToken;
    private final String subjectTokenType;
    private final String actorToken;
    private final String actorTokenType;
    private final Set<String> resources;
    private final Set<String> audiences;
    private final Set<String> scopes;

    public OAuth2TokenExchangeAuthenticationToken(String requestedTokenType, String subjectToken, String subjectTokenType, Authentication clientPrincipal, @Nullable String actorToken, @Nullable String actorTokenType, @Nullable Set<String> resources, @Nullable Set<String> audiences, @Nullable Set<String> scopes, @Nullable Map<String, Object> additionalParameters) {
        super(AuthorizationGrantType.TOKEN_EXCHANGE, clientPrincipal, additionalParameters);
        Assert.hasText((String)requestedTokenType, (String)"requestedTokenType cannot be empty");
        Assert.hasText((String)subjectToken, (String)"subjectToken cannot be empty");
        Assert.hasText((String)subjectTokenType, (String)"subjectTokenType cannot be empty");
        this.requestedTokenType = requestedTokenType;
        this.subjectToken = subjectToken;
        this.subjectTokenType = subjectTokenType;
        this.actorToken = actorToken;
        this.actorTokenType = actorTokenType;
        this.resources = Collections.unmodifiableSet(resources != null ? new LinkedHashSet<String>(resources) : Collections.emptySet());
        this.audiences = Collections.unmodifiableSet(audiences != null ? new LinkedHashSet<String>(audiences) : Collections.emptySet());
        this.scopes = Collections.unmodifiableSet(scopes != null ? new HashSet<String>(scopes) : Collections.emptySet());
    }

    public String getRequestedTokenType() {
        return this.requestedTokenType;
    }

    public String getSubjectToken() {
        return this.subjectToken;
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public String getActorToken() {
        return this.actorToken;
    }

    public String getActorTokenType() {
        return this.actorTokenType;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public Set<String> getAudiences() {
        return this.audiences;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }
}

