/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.util.Assert;

public final class OAuth2TokenExchangeActor
implements ClaimAccessor {
    private final Map<String, Object> claims;

    public OAuth2TokenExchangeActor(Map<String, Object> claims) {
        Assert.notNull(claims, (String)"claims cannot be null");
        this.claims = Collections.unmodifiableMap(claims);
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public String getIssuer() {
        return this.getClaimAsString("iss");
    }

    public String getSubject() {
        return this.getClaimAsString("sub");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OAuth2TokenExchangeActor)) {
            return false;
        }
        OAuth2TokenExchangeActor other = (OAuth2TokenExchangeActor)obj;
        return Objects.equals(this.claims, other.claims);
    }

    public int hashCode() {
        return Objects.hash(this.claims);
    }
}

