/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.List;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OidcLogoutAuthenticationConverter
implements AuthenticationConverter {
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public Authentication convert(HttpServletRequest request) {
        String state;
        String postLogoutRedirectUri;
        String clientId;
        Authentication principal;
        MultiValueMap<String, String> parameters = "GET".equals(request.getMethod()) ? OAuth2EndpointUtils.getQueryParameters(request) : OAuth2EndpointUtils.getFormParameters(request);
        String idTokenHint = (String)parameters.getFirst((Object)"id_token_hint");
        if (!StringUtils.hasText((String)idTokenHint) || ((List)parameters.get((Object)"id_token_hint")).size() != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "id_token_hint");
        }
        if ((principal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        String sessionId = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            sessionId = session.getId();
        }
        if (StringUtils.hasText((String)(clientId = (String)parameters.getFirst((Object)"client_id"))) && ((List)parameters.get((Object)"client_id")).size() != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "client_id");
        }
        if (StringUtils.hasText((String)(postLogoutRedirectUri = (String)parameters.getFirst((Object)"post_logout_redirect_uri"))) && ((List)parameters.get((Object)"post_logout_redirect_uri")).size() != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "post_logout_redirect_uri");
        }
        if (StringUtils.hasText((String)(state = (String)parameters.getFirst((Object)"state"))) && ((List)parameters.get((Object)"state")).size() != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "state");
        }
        return new OidcLogoutAuthenticationToken(idTokenHint, principal, sessionId, clientId, postLogoutRedirectUri, state);
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OpenID Connect 1.0 Logout Request Parameter: " + parameterName, "https://openid.net/specs/openid-connect-rpinitiated-1_0.html#ValidationAndErrorHandling");
        throw new OAuth2AuthenticationException(error);
    }
}

