/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationConsentAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceVerificationAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2DeviceVerificationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceAuthorizationConsentAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceVerificationAuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2DeviceVerificationEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private final List<AuthenticationConverter> deviceVerificationRequestConverters = new ArrayList<AuthenticationConverter>();
    private Consumer<List<AuthenticationConverter>> deviceVerificationRequestConvertersConsumer = deviceVerificationRequestConverters -> {};
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
    private Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer = authenticationProviders -> {};
    private AuthenticationSuccessHandler deviceVerificationResponseHandler;
    private AuthenticationFailureHandler errorResponseHandler;
    private String consentPage;

    OAuth2DeviceVerificationEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OAuth2DeviceVerificationEndpointConfigurer deviceVerificationRequestConverter(AuthenticationConverter deviceVerificationRequestConverter) {
        Assert.notNull((Object)deviceVerificationRequestConverter, (String)"deviceVerificationRequestConverter cannot be null");
        this.deviceVerificationRequestConverters.add(deviceVerificationRequestConverter);
        return this;
    }

    public OAuth2DeviceVerificationEndpointConfigurer deviceVerificationRequestConverters(Consumer<List<AuthenticationConverter>> deviceVerificationRequestConvertersConsumer) {
        Assert.notNull(deviceVerificationRequestConvertersConsumer, (String)"deviceVerificationRequestConvertersConsumer cannot be null");
        this.deviceVerificationRequestConvertersConsumer = deviceVerificationRequestConvertersConsumer;
        return this;
    }

    public OAuth2DeviceVerificationEndpointConfigurer authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProviders.add(authenticationProvider);
        return this;
    }

    public OAuth2DeviceVerificationEndpointConfigurer authenticationProviders(Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer) {
        Assert.notNull(authenticationProvidersConsumer, (String)"authenticationProvidersConsumer cannot be null");
        this.authenticationProvidersConsumer = authenticationProvidersConsumer;
        return this;
    }

    public OAuth2DeviceVerificationEndpointConfigurer deviceVerificationResponseHandler(AuthenticationSuccessHandler deviceVerificationResponseHandler) {
        this.deviceVerificationResponseHandler = deviceVerificationResponseHandler;
        return this;
    }

    public OAuth2DeviceVerificationEndpointConfigurer errorResponseHandler(AuthenticationFailureHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public OAuth2DeviceVerificationEndpointConfigurer consentPage(String consentPage) {
        this.consentPage = consentPage;
        return this;
    }

    @Override
    public void init(HttpSecurity builder) {
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(builder);
        this.requestMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(authorizationServerSettings.getDeviceVerificationEndpoint(), HttpMethod.GET.name()), new AntPathRequestMatcher(authorizationServerSettings.getDeviceVerificationEndpoint(), HttpMethod.POST.name())});
        List<AuthenticationProvider> authenticationProviders = OAuth2DeviceVerificationEndpointConfigurer.createDefaultAuthenticationProviders(builder);
        if (!this.authenticationProviders.isEmpty()) {
            authenticationProviders.addAll(0, this.authenticationProviders);
        }
        this.authenticationProvidersConsumer.accept(authenticationProviders);
        authenticationProviders.forEach(authenticationProvider -> builder.authenticationProvider(this.postProcess(authenticationProvider)));
    }

    @Override
    public void configure(HttpSecurity builder) {
        AuthenticationManager authenticationManager = (AuthenticationManager)builder.getSharedObject(AuthenticationManager.class);
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(builder);
        OAuth2DeviceVerificationEndpointFilter deviceVerificationEndpointFilter = new OAuth2DeviceVerificationEndpointFilter(authenticationManager, authorizationServerSettings.getDeviceVerificationEndpoint());
        List<AuthenticationConverter> authenticationConverters = OAuth2DeviceVerificationEndpointConfigurer.createDefaultAuthenticationConverters();
        if (!this.deviceVerificationRequestConverters.isEmpty()) {
            authenticationConverters.addAll(0, this.deviceVerificationRequestConverters);
        }
        this.deviceVerificationRequestConvertersConsumer.accept(authenticationConverters);
        deviceVerificationEndpointFilter.setAuthenticationConverter(new DelegatingAuthenticationConverter(authenticationConverters));
        if (this.deviceVerificationResponseHandler != null) {
            deviceVerificationEndpointFilter.setAuthenticationSuccessHandler(this.deviceVerificationResponseHandler);
        }
        if (this.errorResponseHandler != null) {
            deviceVerificationEndpointFilter.setAuthenticationFailureHandler(this.errorResponseHandler);
        }
        if (StringUtils.hasText((String)this.consentPage)) {
            deviceVerificationEndpointFilter.setConsentPage(this.consentPage);
        }
        builder.addFilterBefore((Filter)this.postProcess(deviceVerificationEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    private static List<AuthenticationConverter> createDefaultAuthenticationConverters() {
        ArrayList<AuthenticationConverter> authenticationConverters = new ArrayList<AuthenticationConverter>();
        authenticationConverters.add(new OAuth2DeviceVerificationAuthenticationConverter());
        authenticationConverters.add(new OAuth2DeviceAuthorizationConsentAuthenticationConverter());
        return authenticationConverters;
    }

    private static List<AuthenticationProvider> createDefaultAuthenticationProviders(HttpSecurity builder) {
        RegisteredClientRepository registeredClientRepository = OAuth2ConfigurerUtils.getRegisteredClientRepository(builder);
        OAuth2AuthorizationService authorizationService = OAuth2ConfigurerUtils.getAuthorizationService(builder);
        OAuth2AuthorizationConsentService authorizationConsentService = OAuth2ConfigurerUtils.getAuthorizationConsentService(builder);
        ArrayList<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
        OAuth2DeviceVerificationAuthenticationProvider deviceVerificationAuthenticationProvider = new OAuth2DeviceVerificationAuthenticationProvider(registeredClientRepository, authorizationService, authorizationConsentService);
        authenticationProviders.add(deviceVerificationAuthenticationProvider);
        OAuth2DeviceAuthorizationConsentAuthenticationProvider deviceAuthorizationConsentAuthenticationProvider = new OAuth2DeviceAuthorizationConsentAuthenticationProvider(registeredClientRepository, authorizationService, authorizationConsentService);
        authenticationProviders.add(deviceAuthorizationConsentAuthenticationProvider);
        return authenticationProviders;
    }
}

