/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceVerificationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;

public final class OAuth2DeviceVerificationAuthenticationConverter
implements AuthenticationConverter {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public Authentication convert(HttpServletRequest request) {
        Authentication principal;
        if (!"GET".equals(request.getMethod()) && !"POST".equals(request.getMethod())) {
            return null;
        }
        if (request.getParameter("state") != null || request.getParameter("user_code") == null) {
            return null;
        }
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String userCode = (String)parameters.getFirst((Object)"user_code");
        if (!OAuth2EndpointUtils.validateUserCode(userCode) || ((List)parameters.get((Object)"user_code")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "user_code", ERROR_URI);
        }
        if ((principal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!key.equals("user_code")) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        return new OAuth2DeviceVerificationAuthenticationToken(principal, OAuth2EndpointUtils.normalizeUserCode(userCode), additionalParameters);
    }
}

