/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.oauth2.core.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.core.oidc.http.converter.OidcClientRegistrationHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public final class OidcClientRegistrationEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OIDC_CLIENT_REGISTRATION_ENDPOINT_URI = "/connect/register";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher clientRegistrationEndpointMatcher;
    private final HttpMessageConverter<OidcClientRegistration> clientRegistrationHttpMessageConverter = new OidcClientRegistrationHttpMessageConverter();
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();

    public OidcClientRegistrationEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_OIDC_CLIENT_REGISTRATION_ENDPOINT_URI);
    }

    public OidcClientRegistrationEndpointFilter(AuthenticationManager authenticationManager, String clientRegistrationEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)clientRegistrationEndpointUri, (String)"clientRegistrationEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.clientRegistrationEndpointMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(clientRegistrationEndpointUri, HttpMethod.POST.name()), OidcClientRegistrationEndpointFilter.createConfigureClientMatcher(clientRegistrationEndpointUri)});
    }

    private static RequestMatcher createConfigureClientMatcher(String clientRegistrationEndpointUri) {
        AntPathRequestMatcher configureClientGetMatcher = new AntPathRequestMatcher(clientRegistrationEndpointUri, HttpMethod.GET.name());
        RequestMatcher clientIdMatcher = request -> {
            String clientId = request.getParameter("client_id");
            return StringUtils.hasText((String)clientId);
        };
        return new AndRequestMatcher(new RequestMatcher[]{configureClientGetMatcher, clientIdMatcher});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.clientRegistrationEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication = this.convert(request);
            OidcClientRegistrationAuthenticationToken clientRegistrationAuthenticationResult = (OidcClientRegistrationAuthenticationToken)this.authenticationManager.authenticate((Authentication)clientRegistrationAuthentication);
            HttpStatus httpStatus = HttpStatus.OK;
            if (clientRegistrationAuthentication.getClientRegistration() != null) {
                httpStatus = HttpStatus.CREATED;
            }
            this.sendClientRegistrationResponse(response, httpStatus, clientRegistrationAuthenticationResult.getClientRegistration());
        }
        catch (OAuth2AuthenticationException ex) {
            this.sendErrorResponse(response, ex.getError());
        }
        catch (Exception ex) {
            OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Client Registration Error: " + ex.getMessage(), "https://openid.net/specs/openid-connect-registration-1_0.html#RegistrationError");
            this.sendErrorResponse(response, error);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private OidcClientRegistrationAuthenticationToken convert(HttpServletRequest request) throws Exception {
        Authentication principal = SecurityContextHolder.getContext().getAuthentication();
        if ("POST".equals(request.getMethod())) {
            OidcClientRegistration clientRegistration = (OidcClientRegistration)this.clientRegistrationHttpMessageConverter.read(OidcClientRegistration.class, (HttpInputMessage)new ServletServerHttpRequest(request));
            return new OidcClientRegistrationAuthenticationToken(principal, clientRegistration);
        }
        String clientId = request.getParameter("client_id");
        String[] clientIdParameters = request.getParameterValues("client_id");
        if (!StringUtils.hasText((String)clientId) || clientIdParameters.length != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        return new OidcClientRegistrationAuthenticationToken(principal, clientId);
    }

    private void sendClientRegistrationResponse(HttpServletResponse response, HttpStatus httpStatus, OidcClientRegistration clientRegistration) throws IOException {
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(httpStatus);
        this.clientRegistrationHttpMessageConverter.write((Object)clientRegistration, null, (HttpOutputMessage)httpResponse);
    }

    private void sendErrorResponse(HttpServletResponse response, OAuth2Error error) throws IOException {
        HttpStatus httpStatus = HttpStatus.BAD_REQUEST;
        if ("invalid_token".equals(error.getErrorCode())) {
            httpStatus = HttpStatus.UNAUTHORIZED;
        } else if ("insufficient_scope".equals(error.getErrorCode())) {
            httpStatus = HttpStatus.FORBIDDEN;
        } else if ("invalid_client".equals(error.getErrorCode())) {
            httpStatus = HttpStatus.UNAUTHORIZED;
        }
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        httpResponse.setStatusCode(httpStatus);
        this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
    }
}

