/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.context;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.util.Assert;

public final class ProviderContext {
    private final ProviderSettings providerSettings;
    private final Supplier<String> issuerSupplier;

    public ProviderContext(ProviderSettings providerSettings, @Nullable Supplier<String> issuerSupplier) {
        Assert.notNull((Object)providerSettings, (String)"providerSettings cannot be null");
        this.providerSettings = providerSettings;
        this.issuerSupplier = issuerSupplier;
    }

    public ProviderSettings getProviderSettings() {
        return this.providerSettings;
    }

    public String getIssuer() {
        return this.issuerSupplier != null ? this.issuerSupplier.get() : this.getProviderSettings().getIssuer();
    }
}

