/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.OAuth2TokenIntrospectionClaimAccessor;
import org.springframework.security.oauth2.core.Version;
import org.springframework.util.Assert;

public final class OAuth2TokenIntrospection
implements OAuth2TokenIntrospectionClaimAccessor,
Serializable {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private final Map<String, Object> claims;

    private OAuth2TokenIntrospection(Map<String, Object> claims) {
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public static Builder builder() {
        return OAuth2TokenIntrospection.builder(false);
    }

    public static Builder builder(boolean active) {
        return new Builder(active);
    }

    public static Builder withClaims(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        return OAuth2TokenIntrospection.builder().claims(c -> c.putAll(claims));
    }

    public static class Builder {
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        private Builder(boolean active) {
            this.active(active);
        }

        public Builder active(boolean active) {
            return this.claim("active", active);
        }

        public Builder scope(String scope) {
            this.addClaimToClaimList("scope", scope);
            return this;
        }

        public Builder scopes(Consumer<List<String>> scopesConsumer) {
            this.acceptClaimValues("scope", scopesConsumer);
            return this;
        }

        public Builder clientId(String clientId) {
            return this.claim("client_id", clientId);
        }

        public Builder username(String username) {
            return this.claim("username", username);
        }

        public Builder tokenType(String tokenType) {
            return this.claim("token_type", tokenType);
        }

        public Builder expiresAt(Instant expiresAt) {
            return this.claim("exp", expiresAt);
        }

        public Builder issuedAt(Instant issuedAt) {
            return this.claim("iat", issuedAt);
        }

        public Builder notBefore(Instant notBefore) {
            return this.claim("nbf", notBefore);
        }

        public Builder subject(String subject) {
            return this.claim("sub", subject);
        }

        public Builder audience(String audience) {
            this.addClaimToClaimList("aud", audience);
            return this;
        }

        public Builder audiences(Consumer<List<String>> audiencesConsumer) {
            this.acceptClaimValues("aud", audiencesConsumer);
            return this;
        }

        public Builder issuer(String issuer) {
            return this.claim("iss", issuer);
        }

        public Builder id(String jti) {
            return this.claim("jti", jti);
        }

        public Builder claim(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public OAuth2TokenIntrospection build() {
            this.validate();
            return new OAuth2TokenIntrospection(this.claims);
        }

        private void validate() {
            Assert.notNull((Object)this.claims.get("active"), (String)"active cannot be null");
            Assert.isInstanceOf(Boolean.class, (Object)this.claims.get("active"), (String)"active must be of type boolean");
            if (this.claims.containsKey("scope")) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("scope"), (String)"scope must be of type List");
            }
            if (this.claims.containsKey("exp")) {
                Assert.isInstanceOf(Instant.class, (Object)this.claims.get("exp"), (String)"exp must be of type Instant");
            }
            if (this.claims.containsKey("iat")) {
                Assert.isInstanceOf(Instant.class, (Object)this.claims.get("iat"), (String)"iat must be of type Instant");
            }
            if (this.claims.containsKey("nbf")) {
                Assert.isInstanceOf(Instant.class, (Object)this.claims.get("nbf"), (String)"nbf must be of type Instant");
            }
            if (this.claims.containsKey("aud")) {
                Assert.isInstanceOf(List.class, (Object)this.claims.get("aud"), (String)"aud must be of type List");
            }
            if (this.claims.containsKey("iss")) {
                Builder.validateURL(this.claims.get("iss"), "iss must be a valid URL");
            }
        }

        private void addClaimToClaimList(String name, String value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            ((List)this.claims.get(name)).add(value);
        }

        private void acceptClaimValues(String name, Consumer<List<String>> valuesConsumer) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull(valuesConsumer, (String)"valuesConsumer cannot be null");
            this.claims.computeIfAbsent(name, k -> new LinkedList());
            List values = (List)this.claims.get(name);
            valuesConsumer.accept(values);
        }

        private static void validateURL(Object url, String errorMessage) {
            if (URL.class.isAssignableFrom(url.getClass())) {
                return;
            }
            try {
                new URI(url.toString()).toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(errorMessage, ex);
            }
        }
    }
}

