/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import java.util.function.Function;
import javax.servlet.Filter;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcUserInfoEndpointFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class OidcUserInfoEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private Function<OidcUserInfoAuthenticationContext, OidcUserInfo> userInfoMapper;

    OidcUserInfoEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OidcUserInfoEndpointConfigurer userInfoMapper(Function<OidcUserInfoAuthenticationContext, OidcUserInfo> userInfoMapper) {
        this.userInfoMapper = userInfoMapper;
        return this;
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void init(B builder) {
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        String userInfoEndpointUri = providerSettings.getOidcUserInfoEndpoint();
        this.requestMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(userInfoEndpointUri, HttpMethod.GET.name()), new AntPathRequestMatcher(userInfoEndpointUri, HttpMethod.POST.name())});
        OidcUserInfoAuthenticationProvider oidcUserInfoAuthenticationProvider = new OidcUserInfoAuthenticationProvider(OAuth2ConfigurerUtils.getAuthorizationService(builder));
        if (this.userInfoMapper != null) {
            oidcUserInfoAuthenticationProvider.setUserInfoMapper(this.userInfoMapper);
        }
        builder.authenticationProvider((AuthenticationProvider)this.postProcess(oidcUserInfoAuthenticationProvider));
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void configure(B builder) {
        AuthenticationManager authenticationManager = (AuthenticationManager)builder.getSharedObject(AuthenticationManager.class);
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        OidcUserInfoEndpointFilter oidcUserInfoEndpointFilter = new OidcUserInfoEndpointFilter(authenticationManager, providerSettings.getOidcUserInfoEndpoint());
        builder.addFilterAfter((Filter)this.postProcess(oidcUserInfoEndpointFilter), FilterSecurityInterceptor.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }
}

