/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.client;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.KerberosConfig;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.SPNegoSchemeFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class KerberosRestTemplate
extends RestTemplate {
    private static final Credentials credentials = new NullCredentials();
    private final String keyTabLocation;
    private final String userPrincipal;
    private final String password;
    private final Map<String, Object> loginOptions;

    public KerberosRestTemplate() {
        this(null, null, null, null, KerberosRestTemplate.buildHttpClient());
    }

    public KerberosRestTemplate(HttpClient httpClient) {
        this(null, null, null, null, httpClient);
    }

    public KerberosRestTemplate(String keyTabLocation, String userPrincipal) {
        this(keyTabLocation, userPrincipal, KerberosRestTemplate.buildHttpClient());
    }

    public KerberosRestTemplate(String keyTabLocation, String userPrincipal, HttpClient httpClient) {
        this(keyTabLocation, userPrincipal, null, null, httpClient);
    }

    public KerberosRestTemplate(Map<String, Object> loginOptions) {
        this(null, null, null, loginOptions, KerberosRestTemplate.buildHttpClient());
    }

    public KerberosRestTemplate(Map<String, Object> loginOptions, HttpClient httpClient) {
        this(null, null, null, loginOptions, httpClient);
    }

    public KerberosRestTemplate(String keyTabLocation, String userPrincipal, Map<String, Object> loginOptions) {
        this(keyTabLocation, userPrincipal, null, loginOptions, KerberosRestTemplate.buildHttpClient());
    }

    public KerberosRestTemplate(String keyTabLocation, String userPrincipal, String password, Map<String, Object> loginOptions) {
        this(keyTabLocation, userPrincipal, password, loginOptions, KerberosRestTemplate.buildHttpClient());
    }

    private KerberosRestTemplate(String keyTabLocation, String userPrincipal, String password, Map<String, Object> loginOptions, HttpClient httpClient) {
        super((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(httpClient));
        this.keyTabLocation = keyTabLocation;
        this.userPrincipal = userPrincipal;
        this.password = password;
        this.loginOptions = loginOptions;
    }

    private static HttpClient buildHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(KerberosConfig.custom().setStripPort(KerberosConfig.Option.ENABLE).setUseCanonicalHostname(KerberosConfig.Option.DISABLE).build(), (DnsResolver)SystemDefaultDnsResolver.INSTANCE)).build();
        builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        RequestConfig negotiate = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setTargetPreferredAuthSchemes(Set.of("Negotiate", "Kerberos")).build();
        builder.setDefaultRequestConfig(negotiate);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1), credentials);
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        CloseableHttpClient httpClient = builder.build();
        return httpClient;
    }

    private LoginContext buildLoginContext() throws LoginException {
        ClientLoginConfig loginConfig = new ClientLoginConfig(this.keyTabLocation, this.userPrincipal, this.password, this.loginOptions);
        HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
        if (this.userPrincipal != null) {
            princ.add(new KerberosPrincipal(this.userPrincipal));
        }
        Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
        CallbackHandlerImpl callbackHandler = new CallbackHandlerImpl(this.userPrincipal, this.password);
        LoginContext lc = new LoginContext("", sub, callbackHandler, loginConfig);
        return lc;
    }

    protected final <T> T doExecute(final URI url, final String uriTemplate, final HttpMethod method, final RequestCallback requestCallback, final ResponseExtractor<T> responseExtractor) throws RestClientException {
        try {
            LoginContext lc = this.buildLoginContext();
            lc.login();
            Subject serviceSubject = lc.getSubject();
            return Subject.doAs(serviceSubject, new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return KerberosRestTemplate.this.doExecuteSubject(url, uriTemplate, method, requestCallback, responseExtractor);
                }
            });
        }
        catch (Exception ex) {
            throw new RestClientException("Error running rest call", (Throwable)ex);
        }
    }

    private <T> T doExecuteSubject(URI url, String uriTemplate, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return (T)super.doExecute(url, uriTemplate, method, requestCallback, responseExtractor);
    }

    private static final class ClientLoginConfig
    extends Configuration {
        private final String keyTabLocation;
        private final String userPrincipal;
        private final String password;
        private final Map<String, Object> loginOptions;

        private ClientLoginConfig(String keyTabLocation, String userPrincipal, String password, Map<String, Object> loginOptions) {
            this.keyTabLocation = keyTabLocation;
            this.userPrincipal = userPrincipal;
            this.password = password;
            this.loginOptions = loginOptions;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (!StringUtils.hasText((String)this.keyTabLocation) || !StringUtils.hasText((String)this.userPrincipal)) {
                options.put("useTicketCache", "true");
            } else {
                options.put("useKeyTab", "true");
                options.put("keyTab", this.keyTabLocation);
                options.put("principal", this.userPrincipal);
                options.put("storeKey", "true");
            }
            options.put("doNotPrompt", Boolean.toString(this.password == null));
            options.put("isInitiator", "true");
            if (this.loginOptions != null) {
                options.putAll(this.loginOptions);
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    private static final class CallbackHandlerImpl
    implements CallbackHandler {
        private final String userPrincipal;
        private final String password;

        private CallbackHandlerImpl(String userPrincipal, String password) {
            this.userPrincipal = userPrincipal;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.userPrincipal);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unknown Callback");
            }
        }
    }

    private static class NullCredentials
    implements Credentials {
        private NullCredentials() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public char[] getPassword() {
            return null;
        }
    }
}

