/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jwt.crypto.sign;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.RsaKeyHelper;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

public class RsaVerifier
implements SignatureVerifier {
    private final RSAPublicKey key;
    private final String algorithm;

    public RsaVerifier(BigInteger n, BigInteger e) {
        this(RsaKeyHelper.createPublicKey(n, e));
    }

    public RsaVerifier(RSAPublicKey key) {
        this(key, "SHA256withRSA");
    }

    public RsaVerifier(RSAPublicKey key, String algorithm) {
        this.key = key;
        this.algorithm = algorithm;
    }

    public RsaVerifier(String key) {
        this(RsaKeyHelper.parsePublicKey(key.trim()), "SHA256withRSA");
    }

    public void verify(byte[] content, byte[] sig) {
        try {
            Signature signature = Signature.getInstance(this.algorithm);
            signature.initVerify(this.key);
            signature.update(content);
            if (!signature.verify(sig)) {
                throw new InvalidSignatureException("RSA Signature did not match content");
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public String algorithm() {
        return this.algorithm;
    }
}

