/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.data.aot.hint;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.security.aot.hint.AuthorizeReturnObjectHintsRegistrar;
import org.springframework.security.aot.hint.SecurityHintsRegistrar;
import org.springframework.security.authorization.AuthorizationProxyFactory;
import org.springframework.security.authorization.method.AuthorizeReturnObject;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;

public final class AuthorizeReturnObjectDataHintsRegistrar
implements SecurityHintsRegistrar {
    private final AuthorizationProxyFactory proxyFactory;
    private final SecurityAnnotationScanner<AuthorizeReturnObject> scanner = SecurityAnnotationScanners.requireUnique(AuthorizeReturnObject.class);
    private final Set<Class<?>> visitedClasses = new HashSet();

    public AuthorizeReturnObjectDataHintsRegistrar(AuthorizationProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void registerHints(RuntimeHints hints, ConfigurableListableBeanFactory beanFactory) {
        ArrayList<Class> toProxy = new ArrayList<Class>();
        block0: for (String name : beanFactory.getBeanDefinitionNames()) {
            ResolvableType type = beanFactory.getBeanDefinition(name).getResolvableType();
            if (!RepositoryFactoryBeanSupport.class.isAssignableFrom(type.toClass())) continue;
            Class[] generics = type.resolveGenerics();
            Class entity = generics[1];
            AuthorizeReturnObject authorize = (AuthorizeReturnObject)beanFactory.findAnnotationOnBean(name, AuthorizeReturnObject.class);
            if (authorize != null) {
                toProxy.add(entity);
                continue;
            }
            Class repository = generics[0];
            for (Method method : repository.getDeclaredMethods()) {
                AuthorizeReturnObject returnObject = (AuthorizeReturnObject)this.scanner.scan(method, repository);
                if (returnObject == null) continue;
                toProxy.add(entity);
                continue block0;
            }
        }
        new AuthorizeReturnObjectHintsRegistrar(this.proxyFactory, toProxy).registerHints(hints, beanFactory);
    }
}

