/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.WebUtils;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.web.CasGatewayResolverRequestMatcher;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public final class CasGatewayAuthenticationRedirectFilter
extends GenericFilterBean {
    public static final String CAS_GATEWAY_AUTHENTICATION_ATTR = "CAS_GATEWAY_AUTHENTICATION";
    private final String casLoginUrl;
    private final ServiceProperties serviceProperties;
    private RequestMatcher requestMatcher;
    private RequestCache requestCache = new HttpSessionRequestCache();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public CasGatewayAuthenticationRedirectFilter(String casLoginUrl, ServiceProperties serviceProperties) {
        Assert.hasText((String)casLoginUrl, (String)"casLoginUrl cannot be null or empty");
        Assert.notNull((Object)serviceProperties, (String)"serviceProperties cannot be null");
        this.casLoginUrl = casLoginUrl;
        this.serviceProperties = serviceProperties;
        this.requestMatcher = new CasGatewayResolverRequestMatcher(this.serviceProperties);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!this.requestMatcher.matches(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.requestCache.saveRequest(request, response);
        HttpSession session = request.getSession(true);
        session.setAttribute(CAS_GATEWAY_AUTHENTICATION_ATTR, (Object)true);
        String urlEncodedService = WebUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)this.serviceProperties.getService(), null, (String)this.serviceProperties.getServiceParameter(), (String)this.serviceProperties.getArtifactParameter(), (boolean)true);
        String redirectUrl = CommonUtils.constructRedirectUrl((String)this.casLoginUrl, (String)this.serviceProperties.getServiceParameter(), (String)urlEncodedService, (boolean)false, (boolean)true);
        this.redirectStrategy.sendRedirect(request, response, redirectUrl);
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    public void setRequestCache(RequestCache requestCache) {
        Assert.notNull((Object)requestCache, (String)"requestCache cannot be null");
        this.requestCache = requestCache;
    }
}

