/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.authentication;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Deprecated
public class OAuth2AuthenticationDetails
implements Serializable {
    private static final long serialVersionUID = -4809832298438307309L;
    public static final String ACCESS_TOKEN_VALUE = OAuth2AuthenticationDetails.class.getSimpleName() + ".ACCESS_TOKEN_VALUE";
    public static final String ACCESS_TOKEN_TYPE = OAuth2AuthenticationDetails.class.getSimpleName() + ".ACCESS_TOKEN_TYPE";
    private final String remoteAddress;
    private final String sessionId;
    private final String tokenValue;
    private final String tokenType;
    private final String display;
    private Object decodedDetails;

    public OAuth2AuthenticationDetails(HttpServletRequest request) {
        this.tokenValue = (String)request.getAttribute(ACCESS_TOKEN_VALUE);
        this.tokenType = (String)request.getAttribute(ACCESS_TOKEN_TYPE);
        this.remoteAddress = request.getRemoteAddr();
        HttpSession session = request.getSession(false);
        this.sessionId = session != null ? session.getId() : null;
        StringBuilder builder = new StringBuilder();
        if (this.remoteAddress != null) {
            builder.append("remoteAddress=").append(this.remoteAddress);
        }
        if (this.sessionId != null) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append("sessionId=<SESSION>");
        }
        if (this.tokenType != null) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append("tokenType=").append(this.tokenType);
        }
        if (this.tokenValue != null) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append("tokenValue=<TOKEN>");
        }
        this.display = builder.toString();
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Object getDecodedDetails() {
        return this.decodedDetails;
    }

    public void setDecodedDetails(Object decodedDetails) {
        this.decodedDetails = decodedDetails;
    }

    public String toString() {
        return this.display;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        result = 31 * result + (this.tokenType == null ? 0 : this.tokenType.hashCode());
        result = 31 * result + (this.tokenValue == null ? 0 : this.tokenValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2AuthenticationDetails other = (OAuth2AuthenticationDetails)obj;
        if (this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId)) {
            return false;
        }
        if (this.tokenType == null ? other.tokenType != null : !this.tokenType.equals(other.tokenType)) {
            return false;
        }
        return !(this.tokenValue == null ? other.tokenValue != null : !this.tokenValue.equals(other.tokenValue));
    }
}

