/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.ClientCredentialsTokenEndpointFilter;
import org.springframework.security.oauth2.provider.client.ClientDetailsUserDetailsService;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

@Deprecated
public final class AuthorizationServerSecurityConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AccessDeniedHandler accessDeniedHandler = new OAuth2AccessDeniedHandler();
    private PasswordEncoder passwordEncoder;
    private String realm = "oauth2/client";
    private boolean allowFormAuthenticationForClients = false;
    private String tokenKeyAccess = "denyAll()";
    private String checkTokenAccess = "denyAll()";
    private boolean sslOnly = false;
    private List<Filter> tokenEndpointAuthenticationFilters = new ArrayList<Filter>();

    public AuthorizationServerSecurityConfigurer sslOnly() {
        this.sslOnly = true;
        return this;
    }

    public AuthorizationServerSecurityConfigurer allowFormAuthenticationForClients() {
        this.allowFormAuthenticationForClients = true;
        return this;
    }

    public AuthorizationServerSecurityConfigurer realm(String realm) {
        this.realm = realm;
        return this;
    }

    public AuthorizationServerSecurityConfigurer passwordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
        return this;
    }

    public AuthorizationServerSecurityConfigurer authenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
        return this;
    }

    public AuthorizationServerSecurityConfigurer accessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.accessDeniedHandler = accessDeniedHandler;
        return this;
    }

    public AuthorizationServerSecurityConfigurer tokenKeyAccess(String tokenKeyAccess) {
        this.tokenKeyAccess = tokenKeyAccess;
        return this;
    }

    public AuthorizationServerSecurityConfigurer checkTokenAccess(String checkTokenAccess) {
        this.checkTokenAccess = checkTokenAccess;
        return this;
    }

    public String getTokenKeyAccess() {
        return this.tokenKeyAccess;
    }

    public String getCheckTokenAccess() {
        return this.checkTokenAccess;
    }

    public void init(HttpSecurity http) throws Exception {
        this.registerDefaultAuthenticationEntryPoint(http);
        if (this.passwordEncoder != null) {
            ClientDetailsUserDetailsService clientDetailsUserDetailsService = new ClientDetailsUserDetailsService(this.clientDetailsService());
            clientDetailsUserDetailsService.setPasswordEncoder(this.passwordEncoder());
            ((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).userDetailsService((UserDetailsService)clientDetailsUserDetailsService).passwordEncoder(this.passwordEncoder());
        } else {
            http.userDetailsService((UserDetailsService)new ClientDetailsUserDetailsService(this.clientDetailsService()));
        }
        ((HttpSecurity)((HttpSecurity)http.securityContext().securityContextRepository((SecurityContextRepository)new NullSecurityContextRepository()).and()).csrf().disable()).httpBasic().authenticationEntryPoint(this.authenticationEntryPoint).realmName(this.realm);
        if (this.sslOnly) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
        }
    }

    private PasswordEncoder passwordEncoder() {
        return new PasswordEncoder(){

            public boolean matches(CharSequence rawPassword, String encodedPassword) {
                return StringUtils.hasText((String)encodedPassword) ? AuthorizationServerSecurityConfigurer.this.passwordEncoder.matches(rawPassword, encodedPassword) : true;
            }

            public String encode(CharSequence rawPassword) {
                return AuthorizationServerSecurityConfigurer.this.passwordEncoder.encode(rawPassword);
            }
        };
    }

    private void registerDefaultAuthenticationEntryPoint(HttpSecurity http) {
        ContentNegotiationStrategy contentNegotiationStrategy;
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)http.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling == null) {
            return;
        }
        if (this.authenticationEntryPoint == null) {
            BasicAuthenticationEntryPoint basicEntryPoint = new BasicAuthenticationEntryPoint();
            basicEntryPoint.setRealmName(this.realm);
            this.authenticationEntryPoint = basicEntryPoint;
        }
        if ((contentNegotiationStrategy = (ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class)) == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher preferredMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML});
        preferredMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)this.postProcess(this.authenticationEntryPoint), (RequestMatcher)preferredMatcher);
    }

    public void configure(HttpSecurity http) throws Exception {
        this.frameworkEndpointHandlerMapping();
        if (this.allowFormAuthenticationForClients) {
            this.clientCredentialsTokenEndpointFilter(http);
        }
        for (Filter filter : this.tokenEndpointAuthenticationFilters) {
            http.addFilterBefore(filter, BasicAuthenticationFilter.class);
        }
        http.exceptionHandling().accessDeniedHandler(this.accessDeniedHandler);
    }

    private ClientCredentialsTokenEndpointFilter clientCredentialsTokenEndpointFilter(HttpSecurity http) {
        ClientCredentialsTokenEndpointFilter clientCredentialsTokenEndpointFilter = new ClientCredentialsTokenEndpointFilter(this.frameworkEndpointHandlerMapping().getServletPath("/oauth/token"));
        clientCredentialsTokenEndpointFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        OAuth2AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
        authenticationEntryPoint.setTypeName("Form");
        authenticationEntryPoint.setRealmName(this.realm);
        clientCredentialsTokenEndpointFilter.setAuthenticationEntryPoint(authenticationEntryPoint);
        clientCredentialsTokenEndpointFilter = (ClientCredentialsTokenEndpointFilter)((Object)this.postProcess((Object)clientCredentialsTokenEndpointFilter));
        http.addFilterBefore((Filter)clientCredentialsTokenEndpointFilter, BasicAuthenticationFilter.class);
        return clientCredentialsTokenEndpointFilter;
    }

    private ClientDetailsService clientDetailsService() {
        return (ClientDetailsService)((HttpSecurity)this.getBuilder()).getSharedObject(ClientDetailsService.class);
    }

    private FrameworkEndpointHandlerMapping frameworkEndpointHandlerMapping() {
        return (FrameworkEndpointHandlerMapping)((Object)((HttpSecurity)this.getBuilder()).getSharedObject(FrameworkEndpointHandlerMapping.class));
    }

    public void addTokenEndpointAuthenticationFilter(Filter filter) {
        this.tokenEndpointAuthenticationFilters.add(filter);
    }

    public void tokenEndpointAuthenticationFilters(List<Filter> filters) {
        Assert.notNull(filters, (String)"Custom authentication filter list must not be null");
        this.tokenEndpointAuthenticationFilters = new ArrayList<Filter>(filters);
    }
}

