/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store.redis;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collections;
import java.util.List;

class SaferObjectInputStream
extends ObjectInputStream {
    private final List<String> allowedClasses;

    SaferObjectInputStream(InputStream in, List<String> allowedClasses) throws IOException {
        super(in);
        this.allowedClasses = Collections.unmodifiableList(allowedClasses);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        if (this.isProhibited(classDesc.getName())) {
            throw new NotSerializableException("Not allowed to deserialize " + classDesc.getName());
        }
        return super.resolveClass(classDesc);
    }

    private boolean isProhibited(String className) {
        for (String allowedClass : this.allowedClasses) {
            if (!className.startsWith(allowedClass)) continue;
            return false;
        }
        return true;
    }
}

