/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.config.xml.ProviderBeanDefinitionParser;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationManager;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationProcessingFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ResourceServerBeanDefinitionParser
extends ProviderBeanDefinitionParser {
    @Override
    protected AbstractBeanDefinition parseEndpointAndReturnFilter(Element element, ParserContext parserContext, String tokenServicesRef, String serializerRef) {
        String resourceId = element.getAttribute("resource-id");
        String entryPointRef = element.getAttribute("entry-point-ref");
        String authenticationManagerRef = element.getAttribute("authentication-manager-ref");
        String tokenExtractorRef = element.getAttribute("token-extractor-ref");
        String entryAuthDetailsSource = element.getAttribute("auth-details-source-ref");
        BeanDefinitionBuilder protectedResourceFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthenticationProcessingFilter.class);
        if (StringUtils.hasText((String)authenticationManagerRef)) {
            protectedResourceFilterBean.addPropertyReference("authenticationManager", authenticationManagerRef);
        } else {
            BeanDefinitionBuilder authenticationManagerBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthenticationManager.class);
            authenticationManagerBean.addPropertyReference("tokenServices", tokenServicesRef);
            if (StringUtils.hasText((String)resourceId)) {
                authenticationManagerBean.addPropertyValue("resourceId", (Object)resourceId);
            }
            protectedResourceFilterBean.addPropertyValue("authenticationManager", (Object)authenticationManagerBean.getBeanDefinition());
        }
        if (StringUtils.hasText((String)entryPointRef)) {
            protectedResourceFilterBean.addPropertyReference("authenticationEntryPoint", entryPointRef);
        }
        if (StringUtils.hasText((String)entryAuthDetailsSource)) {
            protectedResourceFilterBean.addPropertyReference("authenticationDetailsSource", entryAuthDetailsSource);
        }
        if (StringUtils.hasText((String)tokenExtractorRef)) {
            protectedResourceFilterBean.addPropertyReference("tokenExtractor", tokenExtractorRef);
        }
        return protectedResourceFilterBean.getBeanDefinition();
    }
}

