/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.xml;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static BeanDefinition createSecurityMetadataSource(Element element, ParserContext pc) {
        List filterPatterns = DomUtils.getChildElementsByTagName((Element)element, (String)"url");
        if (filterPatterns.isEmpty()) {
            return null;
        }
        String patternType = element.getAttribute("path-type");
        if (!StringUtils.hasText((String)patternType)) {
            patternType = "ant";
        }
        MatcherType matcherType = MatcherType.valueOf((String)patternType);
        ManagedMap invocationDefinitionMap = new ManagedMap();
        for (Element filterPattern : filterPatterns) {
            String access;
            String method;
            String path = filterPattern.getAttribute("pattern");
            if (!StringUtils.hasText((String)path)) {
                pc.getReaderContext().error("pattern attribute cannot be empty or null", (Object)filterPattern);
            }
            if (!StringUtils.hasText((String)(method = filterPattern.getAttribute("httpMethod")))) {
                method = null;
            }
            if (!StringUtils.hasText((String)(access = filterPattern.getAttribute("resources")))) continue;
            BeanDefinition matcher = matcherType.createMatcher(pc, path, method);
            if (access.equals("none")) {
                invocationDefinitionMap.put((Object)matcher, (Object)BeanDefinitionBuilder.rootBeanDefinition(Collections.class).setFactoryMethod("emptyList").getBeanDefinition());
                continue;
            }
            BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
            attributeBuilder.addConstructorArgValue((Object)access);
            attributeBuilder.setFactoryMethod("createListFromCommaDelimitedString");
            if (invocationDefinitionMap.containsKey((Object)matcher)) {
                pc.getReaderContext().warning("Duplicate URL defined: " + path + ". The original attribute values will be overwritten", pc.extractSource((Object)filterPattern));
            }
            invocationDefinitionMap.put((Object)matcher, (Object)attributeBuilder.getBeanDefinition());
        }
        BeanDefinitionBuilder fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
        fidsBuilder.addConstructorArgValue((Object)invocationDefinitionMap);
        fidsBuilder.getRawBeanDefinition().setSource(pc.extractSource((Object)element));
        return fidsBuilder.getBeanDefinition();
    }

    public static List<BeanMetadataElement> findFilterChain(ParserContext parserContext, String explicitRef) {
        String filterChainRef = explicitRef;
        if (!StringUtils.hasText((String)filterChainRef)) {
            filterChainRef = ConfigUtils.findDefaultFilterChainBeanId(parserContext);
        }
        return (List)parserContext.getRegistry().getBeanDefinition(filterChainRef).getConstructorArgumentValues().getArgumentValue(1, List.class).getValue();
    }

    protected static String findDefaultFilterChainBeanId(ParserContext parserContext) {
        BeanDefinition filterChainList = parserContext.getRegistry().getBeanDefinition("org.springframework.security.filterChains");
        List filterChains = (List)filterChainList.getPropertyValues().getPropertyValue("sourceList").getValue();
        return ((BeanReference)filterChains.get(filterChains.size() - 1)).getBeanName();
    }
}

