/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.http.converter.jaxb;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="oauth")
class JaxbOAuth2AccessToken {
    private String accessToken;
    private Long expiresIn;
    private String refreshToken;

    JaxbOAuth2AccessToken() {
    }

    @XmlElement(name="access_token")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @XmlElement(name="expires_in")
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setExpriation(Date expiration) {
        if (expiration == null) {
            this.setExpiresIn(null);
            return;
        }
        long now = System.currentTimeMillis();
        this.setExpiresIn((expiration.getTime() - now) / 1000L);
    }

    @XmlTransient
    public Date getExpiration() {
        if (this.expiresIn == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        return new Date(now + this.expiresIn * 1000L);
    }

    @XmlElement(name="refresh_token")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}

