/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class JsonDateDeserializer
extends JsonDeserializer<Date> {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        try {
            return dateFormat.parse(parser.getText());
        }
        catch (ParseException e) {
            throw new JsonParseException("Could not parse date", parser.getCurrentLocation(), (Throwable)e);
        }
    }
}

