/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.http.OAuth2ErrorHandler;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.common.AuthenticationScheme;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class OAuth2RestTemplate
extends RestTemplate
implements OAuth2RestOperations {
    private final OAuth2ProtectedResourceDetails resource;
    private AccessTokenProvider accessTokenProvider = new AccessTokenProviderChain(Arrays.asList(new AuthorizationCodeAccessTokenProvider(), new ImplicitAccessTokenProvider(), new ResourceOwnerPasswordAccessTokenProvider(), new ClientCredentialsAccessTokenProvider()));
    private OAuth2ClientContext context;
    private boolean retryBadAccessTokens = true;

    public OAuth2RestTemplate(OAuth2ProtectedResourceDetails resource) {
        this(resource, new DefaultOAuth2ClientContext());
    }

    public OAuth2RestTemplate(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext context) {
        if (resource == null) {
            throw new IllegalArgumentException("An OAuth2 resource must be supplied.");
        }
        this.resource = resource;
        this.context = context;
        this.setErrorHandler(new OAuth2ErrorHandler(resource));
    }

    public void setRetryBadAccessTokens(boolean retryBadAccessTokens) {
        this.retryBadAccessTokens = retryBadAccessTokens;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        if (!(errorHandler instanceof OAuth2ErrorHandler)) {
            errorHandler = new OAuth2ErrorHandler(errorHandler, this.resource);
        }
        super.setErrorHandler(errorHandler);
    }

    protected ClientHttpRequest createRequest(URI uri, HttpMethod method) throws IOException {
        OAuth2AccessToken accessToken = this.getAccessToken();
        String tokenType = accessToken.getTokenType();
        if (!StringUtils.hasText((String)tokenType)) {
            tokenType = "Bearer";
        }
        if ("Bearer".equalsIgnoreCase(tokenType) || "OAuth2".equalsIgnoreCase(tokenType)) {
            AuthenticationScheme bearerTokenMethod = this.resource.getAuthenticationScheme();
            if (AuthenticationScheme.query.equals((Object)bearerTokenMethod) || AuthenticationScheme.form.equals((Object)bearerTokenMethod)) {
                uri = this.appendQueryParameter(uri, accessToken);
            }
            ClientHttpRequest req = super.createRequest(uri, method);
            if (AuthenticationScheme.header.equals((Object)bearerTokenMethod)) {
                req.getHeaders().add("Authorization", String.format("%s %s", "Bearer", accessToken.getValue()));
            }
            return req;
        }
        throw new OAuth2AccessDeniedException("Unsupported access token type: " + tokenType);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        OAuth2AccessToken accessToken = this.context.getAccessToken();
        Object rethrow = null;
        try {
            return (T)super.doExecute(url, method, requestCallback, responseExtractor);
        }
        catch (AccessTokenRequiredException e) {
            rethrow = e;
        }
        catch (OAuth2AccessDeniedException e) {
            rethrow = e;
        }
        catch (InvalidTokenException e) {
            rethrow = new OAuth2AccessDeniedException("Invalid token for client=" + this.getClientId());
        }
        if (accessToken != null && this.retryBadAccessTokens) {
            this.context.setAccessToken(null);
            try {
                return (T)super.doExecute(url, method, requestCallback, responseExtractor);
            }
            catch (InvalidTokenException e) {
                rethrow = new OAuth2AccessDeniedException("Invalid token for client=" + this.getClientId());
            }
        }
        throw rethrow;
    }

    private String getClientId() {
        return this.resource.getClientId();
    }

    @Override
    public OAuth2AccessToken getAccessToken() throws UserRedirectRequiredException {
        OAuth2AccessToken accessToken = this.context.getAccessToken();
        if (accessToken == null || accessToken.isExpired()) {
            try {
                accessToken = this.acquireAccessToken(this.context);
            }
            catch (UserRedirectRequiredException e) {
                this.context.setAccessToken(null);
                accessToken = null;
                String stateKey = e.getStateKey();
                if (stateKey != null) {
                    Object stateToPreserve = e.getStateToPreserve();
                    if (stateToPreserve == null) {
                        stateToPreserve = "NONE";
                    }
                    this.context.setPreservedState(stateKey, stateToPreserve);
                }
                throw e;
            }
        }
        return accessToken;
    }

    @Override
    public OAuth2ClientContext getOAuth2ClientContext() {
        return this.context;
    }

    protected OAuth2AccessToken acquireAccessToken(OAuth2ClientContext oauth2Context) throws UserRedirectRequiredException {
        OAuth2AccessToken existingToken;
        AccessTokenRequest accessTokenRequest = oauth2Context.getAccessTokenRequest();
        if (accessTokenRequest == null) {
            throw new AccessTokenRequiredException("No OAuth 2 security context has been established. Unable to access resource '" + this.resource.getId() + "'.", this.resource);
        }
        String stateKey = accessTokenRequest.getStateKey();
        if (stateKey != null) {
            accessTokenRequest.setPreservedState(oauth2Context.removePreservedState(stateKey));
        }
        if ((existingToken = oauth2Context.getAccessToken()) != null) {
            accessTokenRequest.setExistingToken(existingToken);
        }
        OAuth2AccessToken accessToken = null;
        accessToken = this.accessTokenProvider.obtainAccessToken(this.resource, accessTokenRequest);
        if (accessToken == null || accessToken.getValue() == null) {
            throw new IllegalStateException("Access token provider returned a null access token, which is illegal according to the contract.");
        }
        oauth2Context.setAccessToken(accessToken);
        return accessToken;
    }

    protected URI appendQueryParameter(URI uri, OAuth2AccessToken accessToken) {
        try {
            String query = uri.getRawQuery();
            String queryFragment = this.resource.getTokenName() + "=" + URLEncoder.encode(accessToken.getValue(), "UTF-8");
            query = query == null ? queryFragment : query + "&" + queryFragment;
            URI update = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            StringBuffer sb = new StringBuffer(update.toString());
            sb.append("?");
            sb.append(query);
            if (uri.getFragment() != null) {
                sb.append("#");
                sb.append(uri.getFragment());
            }
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not parse URI", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Could not encode URI", e);
        }
    }

    public void setAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }
}

