/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.exceptions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.common.exceptions.UnauthorizedClientException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.common.exceptions.UnsupportedResponseTypeException;
import org.springframework.security.oauth2.common.exceptions.UserDeniedAuthorizationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ExceptionJackson2Deserializer
extends StdDeserializer<OAuth2Exception> {
    public OAuth2ExceptionJackson2Deserializer() {
        super(OAuth2Exception.class);
    }

    public OAuth2Exception deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String errorMessage;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        HashMap<String, Object> errorParams = new HashMap<String, Object>();
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : (t == JsonToken.START_ARRAY ? jp.readValueAs(List.class) : (t == JsonToken.START_OBJECT ? jp.readValueAs(Map.class) : jp.getText()));
            errorParams.put(fieldName, value);
            t = jp.nextToken();
        }
        Object errorCode = errorParams.get("error");
        String string = errorMessage = errorParams.containsKey("error_description") ? errorParams.get("error_description").toString() : null;
        if (errorMessage == null) {
            String string2 = errorMessage = errorCode == null ? "OAuth Error" : errorCode.toString();
        }
        OAuth2Exception ex = "invalid_client".equals(errorCode) ? new InvalidClientException(errorMessage) : ("unauthorized_client".equals(errorCode) ? new UnauthorizedClientException(errorMessage) : ("invalid_grant".equals(errorCode) ? new InvalidGrantException(errorMessage) : ("invalid_scope".equals(errorCode) ? new InvalidScopeException(errorMessage) : ("invalid_token".equals(errorCode) ? new InvalidTokenException(errorMessage) : ("invalid_request".equals(errorCode) ? new InvalidRequestException(errorMessage) : ("redirect_uri_mismatch".equals(errorCode) ? new RedirectMismatchException(errorMessage) : ("unsupported_grant_type".equals(errorCode) ? new UnsupportedGrantTypeException(errorMessage) : ("unsupported_response_type".equals(errorCode) ? new UnsupportedResponseTypeException(errorMessage) : ("access_denied".equals(errorCode) ? new UserDeniedAuthorizationException(errorMessage) : new OAuth2Exception(errorMessage))))))))));
        Set entries = errorParams.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if ("error".equals(key) || "error_description".equals(key)) continue;
            Object value = entry.getValue();
            ex.addAdditionalInformation(key, value == null ? null : value.toString());
        }
        return ex;
    }
}

