/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.expression;

import java.util.Arrays;
import java.util.HashSet;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionUtils;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class OAuth2WebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    private final Authentication authentication;
    private final boolean throwExceptionOnInvalidScope;

    public OAuth2WebSecurityExpressionRoot(Authentication authentication, FilterInvocation fi, boolean throwExceptionOnInvalidScope) {
        super(authentication, fi);
        this.authentication = authentication;
        this.throwExceptionOnInvalidScope = throwExceptionOnInvalidScope;
    }

    public boolean oauthClientHasRole(String role) {
        return this.oauthClientHasAnyRole(role);
    }

    public boolean oauthClientHasAnyRole(String ... roles) {
        return OAuth2ExpressionUtils.clientHasAnyRole(this.authentication, roles);
    }

    public boolean oauthHasScope(String scope) {
        return this.oauthHasAnyScope(scope);
    }

    public boolean oauthHasAnyScope(String ... scopes) {
        boolean result = OAuth2ExpressionUtils.hasAnyScope(this.authentication, scopes);
        if (!result && this.throwExceptionOnInvalidScope) {
            throw new InvalidScopeException("Invalid scope for this resource scopes", new HashSet<String>(Arrays.asList(scopes)));
        }
        return result;
    }

    public boolean denyOAuthClient() {
        return !OAuth2ExpressionUtils.isOAuth(this.authentication);
    }

    public boolean oauthIsUser() {
        return OAuth2ExpressionUtils.isOAuthUserAuth(this.authentication);
    }

    public boolean oauthIsClient() {
        return OAuth2ExpressionUtils.isOAuthClientAuth(this.authentication);
    }
}

