/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.expression;

import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.expression.OAuth2ExpressionUtils;

public class OAuth2MethodSecurityExpressionHandler
extends DefaultMethodSecurityExpressionHandler {
    public StandardEvaluationContext createEvaluationContextInternal(Authentication auth, MethodInvocation mi) {
        StandardEvaluationContext ec = super.createEvaluationContextInternal(auth, mi);
        ec.addMethodResolver((MethodResolver)new OAuthMethodResolver());
        return ec;
    }

    private static class DenyOAuthClientRoleExecutor
    implements MethodExecutor {
        private DenyOAuthClientRoleExecutor() {
        }

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            return new TypedValue((Object)(!OAuth2ExpressionUtils.isOAuth(((SecurityExpressionRoot)target).getAuthentication()) ? 1 : 0));
        }
    }

    private static class OAuthClientRoleExecutor
    implements MethodExecutor {
        private OAuthClientRoleExecutor() {
        }

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            String[] roles = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                roles[i] = String.valueOf(arguments[i]);
            }
            return new TypedValue((Object)OAuth2ExpressionUtils.clientHasAnyRole(((SecurityExpressionRoot)target).getAuthentication(), roles));
        }
    }

    private static class OAuthScopeExecutor
    implements MethodExecutor {
        private OAuthScopeExecutor() {
        }

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            String[] scopes = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                scopes[i] = String.valueOf(arguments[i]);
            }
            return new TypedValue((Object)OAuth2ExpressionUtils.hasAnyScope(((SecurityExpressionRoot)target).getAuthentication(), scopes));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OAuthMethodResolver
    implements MethodResolver {
        private OAuthMethodResolver() {
        }

        public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
            if (targetObject instanceof SecurityExpressionRoot) {
                if ("oauthClientHasRole".equals(name) || "oauthClientHasAnyRole".equals(name)) {
                    return new OAuthClientRoleExecutor();
                }
                if ("oauthHasScope".equals(name) || "oauthHasAnyScope".equals(name)) {
                    return new OAuthScopeExecutor();
                }
                if ("denyOAuthClient".equals(name)) {
                    return new DenyOAuthClientRoleExecutor();
                }
            }
            return null;
        }
    }
}

